/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.netty.impl.client.proxy;

import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.LastHttpContent;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import org.mule.runtime.http.api.client.proxy.ProxyConfig;
import org.mule.service.http.netty.impl.client.proxy.ProxyAuthenticator;

public class MessageForwardingProxyClientHandler
extends ChannelDuplexHandler {
    private final InetSocketAddress proxyAddress;
    private final ProxyAuthenticator proxyAuthenticator;
    private HttpRequest originalRequest = null;
    private String lastProxyAuthHeader = null;
    private boolean isDanceFinished = false;
    private boolean suppressChannelReadComplete = false;

    public MessageForwardingProxyClientHandler(String proxyHost, int proxyPort, ProxyAuthenticator proxyAuthenticator) {
        this.proxyAuthenticator = proxyAuthenticator;
        this.proxyAddress = new InetSocketAddress(proxyHost, proxyPort);
    }

    public MessageForwardingProxyClientHandler(ProxyConfig proxyConfig) {
        this(proxyConfig.getHost(), proxyConfig.getPort(), new ProxyAuthenticator(proxyConfig));
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (this.isDanceFinished) {
            this.suppressChannelReadComplete = false;
            ctx.fireChannelRead(msg);
            return;
        }
        this.suppressChannelReadComplete = true;
        if (msg instanceof HttpResponse) {
            HttpResponse response = (HttpResponse)msg;
            if (response.status().code() == 200) {
                this.isDanceFinished = true;
                ctx.fireChannelRead(msg);
                return;
            }
            this.lastProxyAuthHeader = this.extractServerProxyAuthHeader(response);
            if (this.lastProxyAuthHeader != null) {
                return;
            }
        }
        if (msg instanceof LastHttpContent && this.lastProxyAuthHeader != null) {
            this.sendAuthenticatedRequestToProxy(ctx, ctx.newPromise());
        }
    }

    private String extractServerProxyAuthHeader(HttpResponse response) {
        return response.headers().get((CharSequence)HttpHeaderNames.PROXY_AUTHENTICATE);
    }

    public void connect(ChannelHandlerContext ctx, SocketAddress remoteAddress, SocketAddress localAddress, ChannelPromise promise) throws Exception {
        ctx.connect((SocketAddress)this.proxyAddress, localAddress, promise);
    }

    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        if (msg instanceof HttpRequest) {
            HttpRequest request;
            this.originalRequest = request = (HttpRequest)msg;
            this.sendAuthenticatedRequestToProxy(ctx, promise);
        } else {
            ctx.write(msg, promise);
        }
    }

    public void channelReadComplete(ChannelHandlerContext ctx) {
        if (this.suppressChannelReadComplete) {
            this.suppressChannelReadComplete = false;
            if (!ctx.channel().config().isAutoRead()) {
                ctx.read();
            }
        } else {
            ctx.fireChannelReadComplete();
        }
    }

    private void sendAuthenticatedRequestToProxy(ChannelHandlerContext ctx, ChannelPromise promise) throws Exception {
        ctx.writeAndFlush((Object)this.addProxyAuthHeaderIfNeeded(this.originalRequest), promise);
    }

    private HttpRequest addProxyAuthHeaderIfNeeded(HttpRequest request) throws Exception {
        if (this.proxyAuthenticator.hasFinished()) {
            return request;
        }
        String proxyAuthorizationHeader = this.proxyAuthenticator.getNextHeader(this.lastProxyAuthHeader);
        if (proxyAuthorizationHeader != null) {
            request.headers().set((CharSequence)HttpHeaderNames.PROXY_AUTHORIZATION, (Object)proxyAuthorizationHeader);
        }
        if (this.proxyAuthenticator.hasFinished()) {
            this.isDanceFinished = true;
        }
        return request;
    }
}

