/*
 * Decompiled with CFR 0.152.
 */
package com.ning.http.client.providers.grizzly;

import org.glassfish.grizzly.filterchain.FilterChainContext;
import org.glassfish.grizzly.filterchain.NextAction;

final class PauseContextHelper {
    private PauseContextHelper() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void requestPause(FilterChainContext ctx) {
        FilterChainContext filterChainContext = ctx;
        synchronized (filterChainContext) {
            PauseContext pauseContext = PauseContextHelper.getPauseCtxFromAttribute(ctx);
            if (null != pauseContext) {
                throw new IllegalStateException("Can't pause an already paused context");
            }
            PauseContextHelper.setPauseCtxAttribute(ctx, new PauseContext(null));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NextAction pauseIfNeeded(FilterChainContext ctx, NextAction pausedAction) {
        if (null == pausedAction || 0 != pausedAction.type()) {
            return pausedAction;
        }
        if (null == PauseContextHelper.getPauseCtxFromAttribute(ctx)) {
            return pausedAction;
        }
        FilterChainContext filterChainContext = ctx;
        synchronized (filterChainContext) {
            PauseContext pauseContext = PauseContextHelper.getPauseCtxFromAttribute(ctx);
            if (pauseContext == null) {
                return pausedAction;
            }
            if (pauseContext.getPausedAction() != null) {
                throw new IllegalStateException("Can't override a paused action");
            }
            PauseContextHelper.setPauseCtxAttribute(ctx, new PauseContext(pausedAction));
            return ctx.getSuspendAction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void resumeFromPausedAction(FilterChainContext ctx) {
        FilterChainContext filterChainContext = ctx;
        synchronized (filterChainContext) {
            PauseContext pauseContext = PauseContextHelper.getPauseCtxFromAttribute(ctx);
            if (pauseContext == null) {
                throw new IllegalStateException("Can't resume a non-paused context");
            }
            PauseContextHelper.removePauseCtxAttribute(ctx);
            if (pauseContext.getPausedAction() == null) {
                return;
            }
            ctx.resume(pauseContext.getPausedAction());
        }
    }

    private static void removePauseCtxAttribute(FilterChainContext ctx) {
        ctx.getAttributes().removeAttribute("PauseContextAttribute");
    }

    private static void setPauseCtxAttribute(FilterChainContext ctx, PauseContext pauseContext) {
        ctx.getAttributes().setAttribute("PauseContextAttribute", (Object)pauseContext);
    }

    private static PauseContext getPauseCtxFromAttribute(FilterChainContext ctx) {
        Object attribute = ctx.getAttributes().getAttribute("PauseContextAttribute");
        if (null == attribute) {
            return null;
        }
        if (attribute instanceof PauseContext) {
            return (PauseContext)attribute;
        }
        return null;
    }

    private static final class PauseContext {
        private static final String NAME = "PauseContextAttribute";
        private final NextAction pausedAction;

        public PauseContext(NextAction pausedAction) {
            this.pausedAction = pausedAction;
        }

        public NextAction getPausedAction() {
            return this.pausedAction;
        }
    }
}

