/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.artifact.api.classloader;

import java.util.List;
import org.mule.api.annotation.NoInstantiate;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.module.artifact.api.classloader.ArtifactClassLoader;
import org.mule.runtime.module.artifact.api.classloader.ArtifactClassLoaderManager;
import org.mule.runtime.module.artifact.api.classloader.DeployableArtifactClassLoaderFactory;
import org.mule.runtime.module.artifact.api.descriptor.ArtifactDescriptor;

@NoInstantiate
public final class TrackingDeployableArtifactClassLoaderFactory<T extends ArtifactDescriptor>
implements DeployableArtifactClassLoaderFactory<T> {
    private final ArtifactClassLoaderManager artifactClassLoaderManager;
    private final DeployableArtifactClassLoaderFactory<T> artifactClassLoaderFactory;

    public TrackingDeployableArtifactClassLoaderFactory(ArtifactClassLoaderManager artifactClassLoaderManager, DeployableArtifactClassLoaderFactory<T> artifactClassLoaderFactory) {
        Preconditions.checkArgument((artifactClassLoaderManager != null ? 1 : 0) != 0, (String)"artifactClassLoaderManager cannot be null");
        Preconditions.checkArgument((artifactClassLoaderFactory != null ? 1 : 0) != 0, (String)"artifactClassLoaderFactory cannot be null");
        this.artifactClassLoaderManager = artifactClassLoaderManager;
        this.artifactClassLoaderFactory = artifactClassLoaderFactory;
    }

    @Override
    public ArtifactClassLoader create(String artifactId, ArtifactClassLoader parent, T descriptor) {
        ArtifactClassLoader artifactClassLoader = this.artifactClassLoaderFactory.create(artifactId, parent, descriptor);
        this.track(artifactClassLoader);
        return artifactClassLoader;
    }

    @Override
    public ArtifactClassLoader create(String artifactId, ArtifactClassLoader parent, T descriptor, List<ArtifactClassLoader> artifactPluginClassLoaders) {
        return this.create(artifactId, parent, descriptor);
    }

    private void track(ArtifactClassLoader artifactClassLoader) {
        this.artifactClassLoaderManager.register(artifactClassLoader);
        artifactClassLoader.addShutdownListener(() -> this.artifactClassLoaderManager.unregister(artifactClassLoader.getArtifactId()));
    }
}

