/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.regex.tregex.parser.flavors;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.regex.RegexSource;
import com.oracle.truffle.regex.RegexSyntaxException;
import com.oracle.truffle.regex.charset.ClassSetContents;
import com.oracle.truffle.regex.charset.CodePointSet;
import com.oracle.truffle.regex.charset.CodePointSetAccumulator;
import com.oracle.truffle.regex.charset.Constants;
import com.oracle.truffle.regex.tregex.buffer.CompilationBuffer;
import com.oracle.truffle.regex.tregex.parser.RegexLexer;
import com.oracle.truffle.regex.tregex.parser.Token;
import com.oracle.truffle.regex.tregex.parser.flavors.OracleDBConstants;
import com.oracle.truffle.regex.tregex.parser.flavors.OracleDBFlags;
import com.oracle.truffle.regex.tregex.string.Encodings;
import com.oracle.truffle.regex.util.JavaStringUtil;
import com.oracle.truffle.regex.util.TBitSet;

public final class OracleDBRegexLexer
extends RegexLexer {
    private static final CodePointSet EMPTY_POSIX_CHAR_CLASS = CodePointSet.create(58, 58, 91, 91, 93, 93);
    private static final TBitSet WHITESPACE = TBitSet.valueOf(10, 32);
    private final OracleDBFlags flags;

    public OracleDBRegexLexer(RegexSource source, OracleDBFlags flags, CompilationBuffer compilationBuffer) {
        super(source, compilationBuffer);
        this.flags = flags;
    }

    @Override
    public boolean hasNext() {
        boolean hasNext = super.hasNext();
        if (this.position == this.pattern.length() - 1 && this.pattern.charAt(this.pattern.length() - 1) == '\\') {
            if (this.inCharacterClass()) {
                throw this.handleUnmatchedLeftBracket();
            }
            return false;
        }
        return hasNext;
    }

    @Override
    protected boolean featureEnabledIgnoreCase() {
        return false;
    }

    @Override
    protected boolean featureEnabledAZPositionAssertions() {
        return true;
    }

    @Override
    protected boolean featureEnabledZLowerCaseAssertion() {
        return true;
    }

    @Override
    protected boolean featureEnabledBoundedQuantifierEmptyMin() {
        return false;
    }

    @Override
    protected boolean featureEnabledPossessiveQuantifiers() {
        return false;
    }

    @Override
    protected boolean featureEnabledCharClassFirstBracketIsLiteral() {
        return true;
    }

    @Override
    protected boolean featureEnabledCCRangeWithPredefCharClass() {
        return false;
    }

    @Override
    protected boolean featureEnabledNestedCharClasses() {
        return true;
    }

    @Override
    protected boolean featureEnabledPOSIXCharClasses() {
        return true;
    }

    @Override
    protected CodePointSet getPOSIXCharClass(String name) {
        if (name.isEmpty()) {
            return EMPTY_POSIX_CHAR_CLASS;
        }
        CodePointSet cps = (CodePointSet)OracleDBConstants.POSIX_CHAR_CLASSES.get((Object)name);
        if (cps != null) {
            return cps;
        }
        throw this.syntaxError("invalid character class in regular expression");
    }

    @Override
    protected void validatePOSIXCollationElement(String sequence) {
        assert (!JavaStringUtil.isSingleCodePoint(sequence));
        throw this.syntaxError("invalid collation class in regular expression");
    }

    @Override
    protected void validatePOSIXEquivalenceClass(String sequence) {
        assert (!JavaStringUtil.isSingleCodePoint(sequence));
        throw this.syntaxError("invalid equivalence class in regular expression");
    }

    @Override
    protected boolean featureEnabledForwardReferences() {
        return false;
    }

    @Override
    protected boolean featureEnabledGroupComments() {
        return false;
    }

    @Override
    protected boolean featureEnabledLineComments() {
        return false;
    }

    @Override
    protected boolean featureEnabledIgnoreWhiteSpace() {
        return this.flags.isIgnoreWhitespace();
    }

    @Override
    protected TBitSet getWhitespace() {
        return WHITESPACE;
    }

    @Override
    protected boolean featureEnabledOctalEscapes() {
        return false;
    }

    @Override
    protected boolean featureEnabledSpecialGroups() {
        return false;
    }

    @Override
    protected boolean featureEnabledUnicodePropertyEscapes() {
        return false;
    }

    @Override
    protected boolean featureEnabledClassSetExpressions() {
        return false;
    }

    @Override
    protected void caseFoldUnfold(CodePointSetAccumulator charClass) {
        throw CompilerDirectives.shouldNotReachHere();
    }

    @Override
    protected ClassSetContents caseFoldClassSetAtom(ClassSetContents classSetContents) {
        throw CompilerDirectives.shouldNotReachHere();
    }

    @Override
    protected CodePointSet complementClassSet(CodePointSet codePointSet) {
        throw CompilerDirectives.shouldNotReachHere();
    }

    @Override
    protected CodePointSet getDotCodePointSet() {
        return this.flags.isDotAll() ? Constants.DOT_ALL : Constants.NO_NEWLINE;
    }

    @Override
    protected CodePointSet getIdContinue() {
        throw CompilerDirectives.shouldNotReachHere();
    }

    @Override
    protected CodePointSet getIdStart() {
        throw CompilerDirectives.shouldNotReachHere();
    }

    @Override
    protected int getMaxBackReferenceDigits() {
        return 1;
    }

    @Override
    protected boolean isPredefCharClass(char c) {
        return !this.inCharacterClass() && PREDEFINED_CHAR_CLASSES.get(c);
    }

    @Override
    protected CodePointSet getPredefinedCharClass(char c) {
        CodePointSet cps = OracleDBRegexLexer.getPOSIXCharClass(c);
        if (OracleDBRegexLexer.isLowerCase(c)) {
            return cps;
        }
        return cps.createInverse(Encodings.UTF_32);
    }

    private static int toLowerCase(char c) {
        return c | 0x20;
    }

    private static boolean isLowerCase(char c) {
        return (c & 0x20) != 0;
    }

    private static CodePointSet getPOSIXCharClass(char c) {
        switch (OracleDBRegexLexer.toLowerCase(c)) {
            case 115: {
                return (CodePointSet)OracleDBConstants.POSIX_CHAR_CLASSES.get((Object)"space");
            }
            case 100: {
                return (CodePointSet)OracleDBConstants.POSIX_CHAR_CLASSES.get((Object)"digit");
            }
            case 119: {
                return OracleDBConstants.WORD_CHARACTERS;
            }
        }
        throw CompilerDirectives.shouldNotReachHere();
    }

    @Override
    protected long boundedQuantifierMaxValue() {
        return 65534L;
    }

    @Override
    protected RegexSyntaxException handleBoundedQuantifierOutOfOrder() {
        return this.syntaxError("invalid interval in regular expression");
    }

    @Override
    protected Token handleBoundedQuantifierEmptyOrMissingMin() throws RegexSyntaxException {
        this.position = this.getLastTokenPosition() + 1;
        return this.literalChar(123);
    }

    @Override
    protected Token handleBoundedQuantifierInvalidCharacter() {
        return this.handleBoundedQuantifierEmptyOrMissingMin();
    }

    @Override
    protected Token handleBoundedQuantifierOverflow(long min, long max) {
        if (Long.compareUnsigned(min, max) > 0) {
            throw this.handleBoundedQuantifierOutOfOrder();
        }
        throw this.syntaxError("invalid interval in regular expression");
    }

    @Override
    protected Token handleBoundedQuantifierOverflowMin(long min, long max) {
        throw this.syntaxError("invalid interval in regular expression");
    }

    @Override
    protected RegexSyntaxException handleCCRangeOutOfOrder(int startPos) {
        return this.syntaxError("invalid range in regular expression");
    }

    @Override
    protected void handleCCRangeWithPredefCharClass(int startPos, ClassSetContents firstAtom, ClassSetContents secondAtom) {
        if ((firstAtom.isAllowedInRange() || !firstAtom.isCodePointSetOnly()) && secondAtom.isCodePointSetOnly()) {
            throw this.syntaxError("invalid range in regular expression");
        }
    }

    @Override
    protected RegexSyntaxException handleComplementOfStringSet() {
        throw CompilerDirectives.shouldNotReachHere();
    }

    @Override
    protected void handleGroupRedefinition(String name, int newId, int oldId) {
        throw CompilerDirectives.shouldNotReachHere();
    }

    @Override
    protected void handleIncompleteEscapeX() {
        throw CompilerDirectives.shouldNotReachHere();
    }

    @Override
    protected Token handleInvalidBackReference(int reference) {
        throw this.syntaxError("invalid back reference in regular expression");
    }

    @Override
    protected RegexSyntaxException handleInvalidCharInCharClass() {
        throw CompilerDirectives.shouldNotReachHere();
    }

    @Override
    protected RegexSyntaxException handleInvalidGroupBeginQ() {
        throw CompilerDirectives.shouldNotReachHere();
    }

    @Override
    protected RegexSyntaxException handleMixedClassSetOperators(RegexLexer.ClassSetOperator leftOperator, RegexLexer.ClassSetOperator rightOperator) {
        throw CompilerDirectives.shouldNotReachHere();
    }

    @Override
    protected RegexSyntaxException handleMissingClassSetOperand(RegexLexer.ClassSetOperator operator) {
        throw CompilerDirectives.shouldNotReachHere();
    }

    @Override
    protected void handleOctalOutOfRange() {
        throw CompilerDirectives.shouldNotReachHere();
    }

    @Override
    protected RegexSyntaxException handleRangeAsClassSetOperand(RegexLexer.ClassSetOperator operator) {
        throw CompilerDirectives.shouldNotReachHere();
    }

    @Override
    protected void handleUnfinishedEscape() {
        throw CompilerDirectives.shouldNotReachHere();
    }

    @Override
    protected void handleUnfinishedGroupComment() {
        throw CompilerDirectives.shouldNotReachHere();
    }

    @Override
    protected RegexSyntaxException handleUnfinishedGroupQ() {
        throw CompilerDirectives.shouldNotReachHere();
    }

    @Override
    protected RegexSyntaxException handleUnfinishedRangeInClassSet() {
        throw CompilerDirectives.shouldNotReachHere();
    }

    @Override
    protected void handleUnmatchedRightBrace() {
    }

    @Override
    protected RegexSyntaxException handleUnmatchedLeftBracket() {
        return this.syntaxError("unmatched bracket in regular expression");
    }

    @Override
    protected void handleUnmatchedRightBracket() {
    }

    @Override
    protected void checkClassSetCharacter(int codePoint) throws RegexSyntaxException {
        throw CompilerDirectives.shouldNotReachHere();
    }

    @Override
    protected int parseCodePointInGroupName() throws RegexSyntaxException {
        throw CompilerDirectives.shouldNotReachHere();
    }

    @Override
    protected Token parseCustomEscape(char c) {
        return null;
    }

    @Override
    protected int parseCustomEscapeChar(char c, boolean inCharClass) {
        if (inCharClass) {
            --this.position;
            return 92;
        }
        return c;
    }

    @Override
    protected int parseCustomEscapeCharFallback(int c, boolean inCharClass) {
        throw CompilerDirectives.shouldNotReachHere();
    }

    @Override
    protected Token parseCustomGroupBeginQ(char charAfterQuestionMark) {
        throw CompilerDirectives.shouldNotReachHere();
    }

    @Override
    protected Token parseGroupLt() {
        throw CompilerDirectives.shouldNotReachHere();
    }
}

