/*
 * Decompiled with CFR 0.152.
 */
package org.raml.yagi.framework.nodes.snakeyaml;

import com.google.common.collect.EvictingQueue;
import java.io.IOException;
import java.io.Reader;
import java.nio.CharBuffer;
import org.yaml.snakeyaml.reader.StreamReader;

class SmartReader
extends Reader {
    private final Reader delegate;
    private char[] lastBufferRead;
    private int lastBufferSize;
    private int lastOffset;

    public SmartReader(Reader delegate) {
        this.delegate = delegate;
    }

    @Override
    public int read(CharBuffer target) throws IOException {
        return this.delegate.read(target);
    }

    @Override
    public int read() throws IOException {
        return this.delegate.read();
    }

    @Override
    public int read(char[] cbuf) throws IOException {
        return this.read(cbuf, 0, cbuf.length);
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        try {
            int numberOfRead = this.delegate.read(cbuf, off, len);
            this.lastBufferRead = cbuf;
            this.lastOffset = off;
            this.lastBufferSize = numberOfRead;
            return numberOfRead;
        }
        catch (IOException e) {
            this.lastBufferSize = 0;
            throw e;
        }
    }

    @Override
    public long skip(long n) throws IOException {
        return this.delegate.skip(n);
    }

    @Override
    public boolean ready() throws IOException {
        return this.delegate.ready();
    }

    @Override
    public boolean markSupported() {
        return this.delegate.markSupported();
    }

    @Override
    public void mark(int readAheadLimit) throws IOException {
        this.delegate.mark(readAheadLimit);
    }

    @Override
    public void reset() throws IOException {
        this.delegate.reset();
    }

    @Override
    public void close() throws IOException {
        this.delegate.close();
    }

    public String getLastValidString() {
        EvictingQueue seen = EvictingQueue.create((int)64);
        for (int i = this.lastOffset; i < this.lastBufferSize; ++i) {
            if (!StreamReader.isPrintable((int)this.lastBufferRead[i])) {
                for (char c : ("[BAD: " + this.lastBufferRead[i] + "]").toCharArray()) {
                    seen.add((Object)Character.valueOf(c));
                }
                break;
            }
            seen.add((Object)Character.valueOf(this.lastBufferRead[i]));
        }
        Character[] foo = (Character[])seen.toArray((Object[])new Character[0]);
        StringBuilder sb = new StringBuilder();
        for (Character character : foo) {
            sb.append(character);
        }
        return sb.toString();
    }
}

