/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.api.config;

import org.mule.runtime.api.component.AbstractComponent;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.core.api.util.queue.DefaultQueueConfiguration;
import org.mule.runtime.core.api.util.queue.QueueConfiguration;
import org.mule.runtime.core.api.util.queue.QueueManager;

public final class QueueProfile
extends AbstractComponent {
    private int maxOutstandingMessages = 0;
    private boolean persistent;

    public static QueueProfile newInstancePersistingToDefaultMemoryQueueStore() {
        return new QueueProfile(false);
    }

    public static QueueProfile newInstanceWithPersistentQueueStore() {
        return new QueueProfile(true);
    }

    public QueueProfile(boolean persistent) {
        this.persistent = persistent;
    }

    public QueueProfile(int maxOutstandingMessages, boolean persistent) {
        this.maxOutstandingMessages = maxOutstandingMessages;
        this.persistent = persistent;
    }

    public int getMaxOutstandingMessages() {
        return this.maxOutstandingMessages;
    }

    public void setMaxOutstandingMessages(int maxOutstandingMessages) {
        this.maxOutstandingMessages = maxOutstandingMessages;
    }

    public QueueConfiguration configureQueue(String component, QueueManager queueManager) throws InitialisationException {
        DefaultQueueConfiguration qc = new DefaultQueueConfiguration(this.maxOutstandingMessages, this.persistent);
        queueManager.setQueueConfiguration(component, qc);
        return qc;
    }

    public String toString() {
        return "QueueProfile{maxOutstandingMessage=" + this.maxOutstandingMessages + ", persistent=" + this.persistent + "}";
    }
}

