/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.netty.impl.server;

import io.netty.channel.ChannelHandlerContext;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.concurrent.ExecutionException;
import org.mule.runtime.http.api.domain.entity.EmptyHttpEntity;
import org.mule.runtime.http.api.domain.entity.HttpEntity;
import org.mule.runtime.http.api.domain.message.request.HttpRequest;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;
import org.mule.runtime.http.api.domain.message.response.HttpResponseBuilder;
import org.mule.runtime.http.api.server.async.HttpResponseReadyCallback;
import org.mule.runtime.http.api.server.async.ResponseStatusCallback;
import org.mule.service.http.netty.impl.server.DirectResponseSender;
import org.mule.service.http.netty.impl.server.StreamingResponseSender;

public class NettyHttp1RequestReadyCallback
implements HttpResponseReadyCallback {
    private final ChannelHandlerContext ctx;
    private final HttpRequest httpRequest;

    public NettyHttp1RequestReadyCallback(ChannelHandlerContext ctx, HttpRequest muleRequest) {
        this.ctx = ctx;
        this.httpRequest = muleRequest;
    }

    public void responseReady(HttpResponse response, ResponseStatusCallback responseStatusCallback) {
        try {
            this.sendResponse(this.ctx, response, responseStatusCallback);
        }
        catch (IOException | InterruptedException | ExecutionException e) {
            responseStatusCallback.responseSendFailure((Throwable)e);
        }
    }

    public Writer startResponse(HttpResponse response, ResponseStatusCallback responseStatusCallback, Charset encoding) {
        return null;
    }

    private void sendResponse(ChannelHandlerContext ctx, HttpResponse response, ResponseStatusCallback callback) throws IOException, ExecutionException, InterruptedException {
        boolean isHeadMethod = this.isHeadMethod(this.httpRequest);
        if (isHeadMethod) {
            response = NettyHttp1RequestReadyCallback.buildResponseWithEmptyBody(response);
        }
        if (response.getEntity().isStreaming()) {
            new StreamingResponseSender(this.httpRequest, ctx, response, callback).send();
        } else {
            new DirectResponseSender(this.httpRequest, ctx, response, callback).send();
        }
        if (isHeadMethod) {
            ctx.close();
        }
    }

    private static HttpResponse buildResponseWithEmptyBody(HttpResponse response) throws IOException {
        if (response.getEntity().isStreaming()) {
            response.getEntity().getContent().close();
        }
        return ((HttpResponseBuilder)new HttpResponseBuilder(response).entity((HttpEntity)new EmptyHttpEntity())).build();
    }

    private boolean isHeadMethod(HttpRequest httpRequest) {
        return httpRequest.getMethod().equals("HEAD");
    }
}

