/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.scheduler.internal.executor;

import java.util.Set;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import org.apache.commons.lang3.StringUtils;
import org.mule.runtime.api.scheduler.SchedulerBusyException;
import org.mule.service.scheduler.internal.RepeatableTaskWrapper;
import org.mule.service.scheduler.internal.executor.AbstractByCallerPolicy;
import org.mule.service.scheduler.internal.executor.WaitPolicy;
import org.mule.service.scheduler.internal.logging.SuppressingLogger;
import org.mule.service.scheduler.internal.service.DefaultSchedulerService;
import org.mule.service.scheduler.internal.threads.SchedulerThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ByCallerThreadGroupPolicy
extends AbstractByCallerPolicy
implements RejectedExecutionHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(ByCallerThreadGroupPolicy.class);
    private final ThreadGroup cpuLightGroup;
    private final ThreadPoolExecutor.AbortPolicy abort;
    private final WaitPolicy wait;
    private final ThreadPoolExecutor.CallerRunsPolicy callerRuns = new ThreadPoolExecutor.CallerRunsPolicy();
    private final Logger traceLogger;
    private volatile long rejectedCount;

    public ByCallerThreadGroupPolicy(Set<ThreadGroup> waitGroups, Set<ThreadGroup> runCpuLightWhenTargetBusyGroups, ThreadGroup cpuLightGroup, ThreadGroup parentGroup, String schedulerName, Logger traceLogger) {
        super(waitGroups, runCpuLightWhenTargetBusyGroups, parentGroup);
        this.abort = new AbortBusyPolicy(schedulerName);
        this.wait = new WaitPolicy(this.abort, schedulerName);
        this.cpuLightGroup = cpuLightGroup;
        this.traceLogger = traceLogger;
    }

    @Override
    public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
        ThreadGroup targetGroup = ((SchedulerThreadFactory)executor.getThreadFactory()).getGroup();
        ThreadGroup currentThreadGroup = Thread.currentThread().getThreadGroup();
        ++this.rejectedCount;
        if (this.isRunCpuLightWhenTargetBusyThread(currentThreadGroup) && targetGroup == this.cpuLightGroup || this.isWaitGroupThread(targetGroup) && targetGroup == currentThreadGroup) {
            if (this.isLogRejectionEnabled()) {
                this.logRejection(r.toString(), this.callerRuns.getClass().getSimpleName(), targetGroup.getName());
            }
            this.callerRuns.rejectedExecution(r, executor);
        } else if (!this.isSchedulerThread(currentThreadGroup) || this.isWaitGroupThread(currentThreadGroup)) {
            if (this.isLogRejectionEnabled()) {
                this.logRejection(r.toString(), this.wait.getClass().getSimpleName(), targetGroup.getName());
            }
            this.wait.rejectedExecution(r, executor);
        } else {
            if (this.isLogRejectionEnabled()) {
                this.logRejection(r.toString(), this.abort.getClass().getSimpleName(), targetGroup.getName());
            }
            this.abort.rejectedExecution(r, executor);
        }
    }

    private boolean isLogRejectionEnabled() {
        return DefaultSchedulerService.USAGE_TRACE_INTERVAL_SECS != null ? this.traceLogger.isWarnEnabled() : this.traceLogger.isDebugEnabled();
    }

    private void logRejection(String taskAsString, String strategy, String targetAsString) {
        if (DefaultSchedulerService.USAGE_TRACE_INTERVAL_SECS != null) {
            this.traceLogger.warn("Task rejected ({}) from '{}' scheduler: {}", new Object[]{StringUtils.rightPad((String)strategy, (int)16), targetAsString, taskAsString});
        } else {
            this.traceLogger.debug("Task rejected ({}) from '{}' scheduler: {}", new Object[]{StringUtils.rightPad((String)strategy, (int)16), targetAsString, taskAsString});
        }
    }

    public long getRejectedCount() {
        return this.rejectedCount;
    }

    private static final class AbortBusyPolicy
    extends ThreadPoolExecutor.AbortPolicy {
        private final String schedulerName;
        private final SuppressingLogger suppressionLogger;

        public AbortBusyPolicy(String schedulerName) {
            this.schedulerName = schedulerName;
            this.suppressionLogger = new SuppressingLogger(LOGGER, 5000L, "Similar log entries will be suppressed for the following 5 seconds for scheduler '" + schedulerName + "'.");
        }

        @Override
        public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
            String msg = "Task '" + r.toString() + "' rejected from Scheduler '" + this.schedulerName + "' ('" + executor.toString() + "')";
            if (!executor.isShutdown() && !(r instanceof RepeatableTaskWrapper)) {
                this.suppressionLogger.log(msg);
            }
            throw new SchedulerBusyException(msg);
        }
    }
}

