/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.extension;

import org.mule.metadata.api.model.ArrayType;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.message.api.MessageMetadataType;
import org.mule.metadata.message.api.MessageMetadataTypeBuilder;
import org.mule.sdk.api.metadata.ChainInputMetadataContext;
import org.mule.sdk.api.metadata.resolving.ChainInputTypeResolver;

public class ForEachChainInputTypeResolver
implements ChainInputTypeResolver {
    private static final String PARAMETER_NAME = "collection";

    public MessageMetadataType getChainInputMetadataType(ChainInputMetadataContext context) {
        MessageMetadataType messageMetadataType = context.getInputMessageMetadataType();
        MessageMetadataTypeBuilder chainMessageMetadataTypeBuilder = MessageMetadataType.builder();
        messageMetadataType.getAttributesType().ifPresent(arg_0 -> ((MessageMetadataTypeBuilder)chainMessageMetadataTypeBuilder).attributes(arg_0));
        chainMessageMetadataTypeBuilder.payload(this.resolveChainPayloadType(context.getParameterResolvedType(PARAMETER_NAME)));
        return chainMessageMetadataTypeBuilder.build();
    }

    public String getCategoryName() {
        return "FOREACH";
    }

    public String getResolverName() {
        return "FOREACH_CHAIN_INPUT";
    }

    private MetadataType resolveChainPayloadType(MetadataType collectionType) {
        if (!(collectionType instanceof ArrayType)) {
            throw new IllegalArgumentException(String.format("Expected a collection from parameter `%s`", PARAMETER_NAME));
        }
        return ((ArrayType)collectionType).getType();
    }
}

