/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.routing;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.inject.Inject;
import org.mule.runtime.api.component.AbstractComponent;
import org.mule.runtime.api.component.Component;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.lifecycle.Lifecycle;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.context.MuleContextAware;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.api.processor.ReactiveProcessor;
import org.mule.runtime.core.internal.routing.AbstractSinkRouter;
import org.mule.runtime.core.internal.routing.ProcessorRoute;
import org.mule.runtime.core.internal.routing.result.CouldNotRouteOutboundMessageException;
import org.mule.runtime.core.internal.routing.result.RoutingException;
import org.mule.runtime.core.privileged.processor.MessageProcessors;
import org.mule.runtime.core.privileged.processor.Router;
import org.mule.runtime.tracer.api.component.ComponentTracerFactory;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;

public class RoundRobin
extends AbstractComponent
implements Router,
Lifecycle,
MuleContextAware {
    public static final String ROUND_ROBIN_ROUTE_SPAN_NAME_SUFFIX = ":route";
    private final AtomicBoolean started = new AtomicBoolean(false);
    private final List<ProcessorRoute> routes = new ArrayList<ProcessorRoute>();
    private final AtomicInteger index = new AtomicInteger(0);
    private MuleContext muleContext;
    @Inject
    ComponentTracerFactory componentTracerFactory;

    public void setMuleContext(MuleContext context) {
        this.muleContext = context;
    }

    public void setRoutes(Collection<Processor> routes) {
        routes.forEach(this::addRoute);
    }

    public void initialise() throws InitialisationException {
        for (ProcessorRoute route : this.routes) {
            route.setComponentTracer(this.componentTracerFactory.fromComponent((Component)this, ROUND_ROBIN_ROUTE_SPAN_NAME_SUFFIX));
            LifecycleUtils.initialiseIfNeeded((Object)((Object)route), (MuleContext)this.muleContext);
        }
    }

    public void start() throws MuleException {
        for (ProcessorRoute route : this.routes) {
            route.start();
        }
        this.started.set(true);
    }

    public void stop() throws MuleException {
        for (ProcessorRoute route : this.routes) {
            route.stop();
        }
        this.started.set(false);
    }

    public void dispose() {
        for (ProcessorRoute route : this.routes) {
            route.dispose();
        }
    }

    public void addRoute(Processor processor) {
        this.routes.add(new ProcessorRoute(processor, this.componentTracerFactory));
    }

    public CoreEvent process(CoreEvent event) throws MuleException {
        return MessageProcessors.processToApply((CoreEvent)event, (ReactiveProcessor)this);
    }

    public Publisher<CoreEvent> apply(Publisher<CoreEvent> publisher) {
        return Flux.merge(new SinkRouter(publisher, this.routes).collectPublishers());
    }

    private int getAndIncrementModuloN(int modulus) {
        if (modulus == 0) {
            return -1;
        }
        return this.index.getAndUpdate(lastIndex -> (lastIndex + 1) % modulus);
    }

    private class SinkRouter
    extends AbstractSinkRouter {
        SinkRouter(Publisher<CoreEvent> publisher, List<ProcessorRoute> routes) {
            super(publisher, routes, RoundRobin.this.componentTracerFactory);
        }

        @Override
        protected void route(CoreEvent event) throws RoutingException {
            int modulo = RoundRobin.this.getAndIncrementModuloN(RoundRobin.this.routes.size());
            if (modulo < 0) {
                throw new CouldNotRouteOutboundMessageException((Processor)RoundRobin.this);
            }
            this.getRoutes().get(modulo).execute(event);
        }
    }
}

