/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.api.properties;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.mule.runtime.api.component.ConfigurationProperties;
import org.mule.runtime.api.config.FeatureFlaggingService;
import org.mule.runtime.ast.api.ArtifactAst;
import org.mule.runtime.config.api.properties.ConfigurationPropertiesResolver;
import org.mule.runtime.config.internal.model.dsl.ClassLoaderResourceProvider;
import org.mule.runtime.config.internal.model.dsl.config.PropertiesResolverConfigurationProperties;
import org.mule.runtime.config.internal.model.properties.PropertiesHierarchyCreationUtils;

public interface ConfigurationPropertiesResolverProvider
extends ConfigurationProperties {
    public static ConfigurationPropertiesResolverProvider fromResolver(ConfigurationPropertiesResolver configurationPropertiesResolver) {
        return new PropertiesResolverConfigurationProperties(configurationPropertiesResolver);
    }

    public static Builder builder() {
        return new Builder();
    }

    public ConfigurationPropertiesResolver getConfigurationPropertiesResolver();

    public static final class Builder {
        private ArtifactAst artifactAst;
        private Optional<ConfigurationProperties> parentConfigurationProperties = Optional.empty();
        private Map<String, String> deploymentProperties;
        private ClassLoader artifactClassLoader;
        private Optional<FeatureFlaggingService> featureFlaggingService = Optional.empty();

        public Builder from(ArtifactAst artifactAst) {
            this.artifactAst = artifactAst;
            return this;
        }

        public Builder withParentProperties(Optional<ConfigurationProperties> parentConfigurationProperties) {
            this.parentConfigurationProperties = parentConfigurationProperties;
            return this;
        }

        public Builder withDeploymentProperties(Map<String, String> deploymentProperties) {
            this.deploymentProperties = deploymentProperties;
            return this;
        }

        public Builder loadingResourcesWith(ClassLoader artifactClassLoader) {
            this.artifactClassLoader = artifactClassLoader;
            return this;
        }

        public Builder withFeatureFlags(Optional<FeatureFlaggingService> featureFlaggingService) {
            this.featureFlaggingService = featureFlaggingService;
            return this;
        }

        public ConfigurationPropertiesResolverProvider build() {
            return PropertiesHierarchyCreationUtils.createConfigurationAttributeResolver(Objects.requireNonNull(this.artifactAst), Objects.requireNonNull(this.parentConfigurationProperties), Objects.requireNonNull(this.deploymentProperties), new ClassLoaderResourceProvider(Objects.requireNonNull(this.artifactClassLoader)), Objects.requireNonNull(this.featureFlaggingService));
        }
    }
}

