/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.soap.internal.loader;

import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.Map;
import java.util.Set;
import org.mule.metadata.api.ClassTypeLoader;
import org.mule.metadata.api.annotation.TypeAnnotation;
import org.mule.metadata.api.annotation.TypeIdAnnotation;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.builder.TypeBuilder;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.api.model.impl.DefaultStringType;
import org.mule.metadata.java.api.JavaTypeLoader;
import org.mule.metadata.java.api.annotation.ClassInformationAnnotation;
import org.mule.runtime.api.meta.model.ModelProperty;
import org.mule.runtime.api.meta.model.ParameterDslConfiguration;
import org.mule.runtime.api.meta.model.declaration.fluent.ConfigurationDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.OperationDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.OptionalParameterDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.ParameterGroupDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.ParameterizedDeclarer;
import org.mule.runtime.api.meta.model.display.DisplayModel;
import org.mule.runtime.api.meta.model.display.LayoutModel;
import org.mule.runtime.api.meta.model.error.ErrorModel;
import org.mule.runtime.api.meta.model.parameter.ParameterRole;
import org.mule.runtime.api.metadata.resolving.InputTypeResolver;
import org.mule.runtime.api.metadata.resolving.OutputTypeResolver;
import org.mule.runtime.api.metadata.resolving.TypeKeysResolver;
import org.mule.runtime.extension.api.declaration.type.annotation.TypedValueTypeAnnotation;
import org.mule.runtime.extension.api.metadata.ComponentMetadataConfigurerFactory;
import org.mule.runtime.extension.api.property.MetadataKeyPartModelProperty;
import org.mule.runtime.extension.api.runtime.operation.CompletableComponentExecutorFactory;
import org.mule.runtime.extension.api.soap.SoapAttributes;
import org.mule.runtime.extension.api.soap.SoapOutputPayload;
import org.mule.runtime.module.extension.api.loader.java.property.CompletableComponentExecutorModelProperty;
import org.mule.runtime.module.extension.api.loader.java.type.Type;
import org.mule.runtime.module.extension.internal.loader.ParameterGroupDescriptor;
import org.mule.runtime.module.extension.internal.loader.delegate.StereotypeModelLoaderDelegate;
import org.mule.runtime.module.extension.internal.loader.java.property.ConnectivityModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.property.DeclaringMemberModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.property.ParameterGroupModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.type.runtime.TypeWrapper;
import org.mule.runtime.module.extension.internal.util.IntrospectionUtils;
import org.mule.runtime.module.extension.internal.util.ReflectionCache;
import org.mule.runtime.module.extension.soap.internal.metadata.InvokeInputAttachmentsTypeResolver;
import org.mule.runtime.module.extension.soap.internal.metadata.InvokeInputHeadersTypeResolver;
import org.mule.runtime.module.extension.soap.internal.metadata.InvokeKeysResolver;
import org.mule.runtime.module.extension.soap.internal.metadata.InvokeOutputTypeResolver;
import org.mule.runtime.module.extension.soap.internal.metadata.InvokeRequestTypeResolver;
import org.mule.runtime.module.extension.soap.internal.metadata.WebServiceTypeKey;
import org.mule.runtime.module.extension.soap.internal.runtime.connection.ForwardingSoapClient;
import org.mule.runtime.module.extension.soap.internal.runtime.operation.SoapOperationExecutorFactory;

public class SoapInvokeOperationDeclarer {
    public static final String MESSAGE_GROUP = "Message";
    private static final String KEYS_GROUP = "Web Service Configuration";
    static final String TRANSPORT = "Transport";
    static final String TRANSPORT_GROUP = "Transport Configuration";
    static final String OPERATION_DESCRIPTION = "invokes Web Service operations";
    static final String OPERATION_NAME = "invoke";
    public static final String SERVICE_PARAM = "service";
    public static final String OPERATION_PARAM = "operation";
    public static final String HEADERS_PARAM = "headers";
    public static final String BODY_PARAM = "body";
    public static final String ATTACHMENTS_PARAM = "attachments";
    public static final String HEADERS_DISPLAY_NAME = "Headers";
    public static final String TRANSPORT_HEADERS_PARAM = "transportHeaders";
    private static final BaseTypeBuilder TYPE_BUILDER = BaseTypeBuilder.create((MetadataFormat)JavaTypeLoader.JAVA);
    private final StereotypeModelLoaderDelegate stereotypeDelegate;

    public SoapInvokeOperationDeclarer(StereotypeModelLoaderDelegate stereotypeDelegate) {
        this.stereotypeDelegate = stereotypeDelegate;
    }

    void declare(ConfigurationDeclarer configDeclarer, ClassTypeLoader loader, Set<ErrorModel> soapErrors) {
        ReflectionCache reflectionCache = new ReflectionCache();
        OperationDeclarer operation = (OperationDeclarer)((OperationDeclarer)((OperationDeclarer)((OperationDeclarer)((OperationDeclarer)configDeclarer.withOperation(OPERATION_NAME).describedAs(OPERATION_DESCRIPTION)).requiresConnection(true)).blocking(true).withStereotype(this.stereotypeDelegate.getDefaultOperationStereotype(OPERATION_NAME))).withModelProperty((ModelProperty)new CompletableComponentExecutorModelProperty((CompletableComponentExecutorFactory)new SoapOperationExecutorFactory()))).withModelProperty((ModelProperty)new ConnectivityModelProperty(ForwardingSoapClient.class));
        soapErrors.forEach(arg_0 -> ((OperationDeclarer)operation).withErrorModel(arg_0));
        this.declareMetadata(operation, loader);
        this.declareOutput(operation, loader);
        this.declareMetadataKeyParameters(operation, loader, reflectionCache);
        this.declareRequestParameters(operation, loader);
    }

    private void declareMetadata(OperationDeclarer operation, ClassTypeLoader loader) {
        ComponentMetadataConfigurerFactory.getDefault().create().setKeysResolver((TypeKeysResolver)new InvokeKeysResolver(), KEYS_GROUP, loader.load(WebServiceTypeKey.class), false).addInputResolver(BODY_PARAM, (InputTypeResolver)new InvokeRequestTypeResolver()).addInputResolver(HEADERS_PARAM, (InputTypeResolver)new InvokeInputHeadersTypeResolver()).addInputResolver(ATTACHMENTS_PARAM, (InputTypeResolver)new InvokeInputAttachmentsTypeResolver()).setOutputTypeResolver((OutputTypeResolver)new InvokeOutputTypeResolver()).setConnected(true).configure((ParameterizedDeclarer)operation);
    }

    private void declareOutput(OperationDeclarer operation, ClassTypeLoader loader) {
        operation.withOutput().ofDynamicType(loader.load(SoapOutputPayload.class));
        operation.withOutputAttributes().ofType(loader.load(SoapAttributes.class));
    }

    private void declareRequestParameters(OperationDeclarer operation, ClassTypeLoader loader) {
        ParameterGroupDeclarer message = operation.onParameterGroup(MESSAGE_GROUP).withDslInlineRepresentation(true).withLayout(this.getLayout(1));
        MetadataType binaryType = loader.load(InputStream.class);
        ObjectType attachments = TYPE_BUILDER.objectType().openWith((TypeBuilder)TYPE_BUILDER.binaryType().id(InputStream.class.getName()).with((TypeAnnotation)new TypedValueTypeAnnotation())).with((TypeAnnotation)new TypeIdAnnotation(Map.class.getName())).with((TypeAnnotation)new ClassInformationAnnotation(Map.class)).build();
        ((OptionalParameterDeclarer)((OptionalParameterDeclarer)((OptionalParameterDeclarer)message.withOptionalParameter(BODY_PARAM).ofDynamicType(binaryType)).withRole(ParameterRole.PRIMARY_CONTENT)).defaultingTo((Object)"#[payload]").withLayout(this.getLayout(3))).withDisplayModel(DisplayModel.builder().summary("The XML body to include in the SOAP message, with all the required parameters.").build());
        ((OptionalParameterDeclarer)((OptionalParameterDeclarer)((OptionalParameterDeclarer)message.withOptionalParameter(HEADERS_PARAM).ofDynamicType(binaryType)).withRole(ParameterRole.CONTENT)).withLayout(this.getLayout(4))).withDisplayModel(DisplayModel.builder().displayName(HEADERS_DISPLAY_NAME).summary("The XML headers to include in the SOAP message.").build());
        ((OptionalParameterDeclarer)((OptionalParameterDeclarer)((OptionalParameterDeclarer)message.withOptionalParameter(ATTACHMENTS_PARAM).ofDynamicType((MetadataType)attachments)).withRole(ParameterRole.CONTENT)).withLayout(this.getLayout(5))).withDisplayModel(DisplayModel.builder().summary("The attachments to include in the SOAP request.").build());
        ((OptionalParameterDeclarer)((OptionalParameterDeclarer)((OptionalParameterDeclarer)operation.onParameterGroup(TRANSPORT_GROUP).withLayout(this.getLayout(2)).withOptionalParameter(TRANSPORT_HEADERS_PARAM).ofType((MetadataType)TYPE_BUILDER.objectType().openWith(loader.load(String.class)).with((TypeAnnotation)new TypeIdAnnotation(Map.class.getName())).with((TypeAnnotation)new ClassInformationAnnotation(Map.class)).build())).withDsl(ParameterDslConfiguration.getDefaultInstance())).withLayout(LayoutModel.builder().order(2).tabName(TRANSPORT).build())).withDisplayModel(DisplayModel.builder().displayName(HEADERS_DISPLAY_NAME).summary("The headers to set in the transport configuration.").build());
    }

    private void declareMetadataKeyParameters(OperationDeclarer operation, ClassTypeLoader loader, ReflectionCache reflectionCache) {
        TypeWrapper keyType = new TypeWrapper(WebServiceTypeKey.class, loader);
        ParameterGroupDeclarer group = operation.onParameterGroup(KEYS_GROUP).withModelProperty((ModelProperty)new ParameterGroupModelProperty(new ParameterGroupDescriptor(KEYS_GROUP, (Type)keyType)));
        DefaultStringType stringType = TYPE_BUILDER.stringType().build();
        group.withRequiredParameter(SERVICE_PARAM).withModelProperty((ModelProperty)new DeclaringMemberModelProperty((Field)IntrospectionUtils.getField(WebServiceTypeKey.class, (String)SERVICE_PARAM, (ReflectionCache)reflectionCache).get())).ofType((MetadataType)stringType).withModelProperty((ModelProperty)new MetadataKeyPartModelProperty(1)).withLayout(this.getLayout(1));
        group.withRequiredParameter(OPERATION_PARAM).ofType((MetadataType)stringType).withModelProperty((ModelProperty)new DeclaringMemberModelProperty((Field)IntrospectionUtils.getField(WebServiceTypeKey.class, (String)OPERATION_PARAM, (ReflectionCache)reflectionCache).get())).withModelProperty((ModelProperty)new MetadataKeyPartModelProperty(2)).withLayout(this.getLayout(2));
    }

    private LayoutModel getLayout(int order) {
        return LayoutModel.builder().order(order).build();
    }
}

