/*
 * Decompiled with CFR 0.152.
 */
package org.raml.yagi.framework.util;

import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Collection;
import org.apache.commons.lang.StringUtils;
import org.raml.yagi.framework.nodes.ErrorNode;
import org.raml.yagi.framework.nodes.Node;
import org.raml.yagi.framework.nodes.ReferenceNode;
import org.raml.yagi.framework.nodes.SimpleTypeNode;
import org.raml.yagi.framework.nodes.StringNode;

public class FasterTreeNodeDumper {
    private static final int TAB_SPACES = 4;
    protected PrintWriter dump;
    private int indent = 0;
    private boolean dumpOn = true;

    private FasterTreeNodeDumper(PrintWriter dump) {
        this.dump = dump;
    }

    public FasterTreeNodeDumper() {
        this(new PrintWriter(new OutputStreamWriter(System.out)));
    }

    public String dump(Node node) {
        this.printIndent();
        this.dumpNode(node);
        this.dump.print(" (");
        this.dump.print("Start: " + node.getStartPosition().getIndex());
        this.dump.print(" , End: " + node.getEndPosition().getIndex());
        if (node.getStartPosition().getIndex() != -1 && node.getEndPosition().getIndex() != -1 && this.dumpOn) {
            this.dump.print(", On: " + node.getStartPosition().getPath());
        }
        if (node.getSource() != null) {
            this.dump.print(", Source: ");
            this.dump.print(node.getSource().getClass().getSimpleName());
        }
        this.dump.print(")");
        this.dump.print("\n");
        this.indent();
        this.dumpChildren(node);
        this.dedent();
        return "";
    }

    protected void dumpChildren(Node node) {
        for (Node child : this.getChildren(node)) {
            this.dump(child);
        }
    }

    public FasterTreeNodeDumper dumpOn(boolean dumpOn) {
        this.dumpOn = dumpOn;
        return this;
    }

    protected Collection<Node> getChildren(Node node) {
        return node.getChildren();
    }

    protected void dumpNode(Node node) {
        this.dump.append(node.getClass().getSimpleName());
        if (node instanceof ReferenceNode) {
            this.dumpReference((ReferenceNode)node);
        } else if (node instanceof StringNode) {
            this.dump.append(": \"").append(((StringNode)node).getValue().replace("\n", "\\n")).append("\"");
        } else if (node instanceof SimpleTypeNode) {
            this.dump.append(": ").print(((SimpleTypeNode)node).getValue());
        } else if (node instanceof ErrorNode) {
            this.dump.append(": \"").append(((ErrorNode)node).getErrorMessage()).append("\"");
        }
    }

    private void dumpReference(ReferenceNode node) {
        ReferenceNode referenceNode = node;
        Node refNode = referenceNode.getRefNode();
        this.dump.print(" " + referenceNode.getRefName() + " -> {" + (refNode == null ? "null" : refNode.getClass().getSimpleName()));
        if (refNode != null) {
            this.dump.append(" RefStart: " + refNode.getStartPosition().getIndex());
            this.dump.append(" , RefEnd: " + refNode.getEndPosition().getIndex());
        }
        this.dump.append("}");
    }

    protected void dedent() {
        --this.indent;
    }

    protected void indent() {
        ++this.indent;
    }

    protected void printIndent() {
        this.dump.append(StringUtils.repeat((String)" ", (int)(this.indent * 4)));
    }
}

