/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.tooling.internal.utils;

import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.java.api.utils.JavaTypeUtils;
import org.mule.runtime.api.component.location.ConfigurationComponentLocator;
import org.mule.runtime.api.component.location.Location;
import org.mule.runtime.api.event.Event;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.api.meta.model.EnrichableModel;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.api.meta.model.stereotype.StereotypeModel;
import org.mule.runtime.api.util.Reference;
import org.mule.runtime.app.declaration.api.ArtifactDeclaration;
import org.mule.runtime.app.declaration.api.ComponentElementDeclaration;
import org.mule.runtime.app.declaration.api.ConfigurationElementDeclaration;
import org.mule.runtime.app.declaration.api.ElementDeclaration;
import org.mule.runtime.app.declaration.api.GlobalElementDeclarationVisitor;
import org.mule.runtime.app.declaration.api.IdentifiableElementDeclaration;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.extension.ExtensionManager;
import org.mule.runtime.core.internal.event.NullEventFactory;
import org.mule.runtime.core.privileged.event.BaseEventContext;
import org.mule.runtime.extension.api.runtime.config.ConfigurationInstance;
import org.mule.runtime.extension.api.runtime.config.ConfigurationProvider;
import org.mule.runtime.module.extension.internal.util.MuleExtensionUtils;
import org.mule.runtime.module.tooling.internal.utils.ArtifactHelperUtils;

public class ArtifactHelper {
    private ExtensionManager extensionManager;
    private ArtifactDeclaration artifactDeclaration;
    private ConfigurationComponentLocator componentLocator;

    public ArtifactHelper(ExtensionManager extensionManager, ConfigurationComponentLocator componentLocator, ArtifactDeclaration artifactDeclaration) {
        this.extensionManager = extensionManager;
        this.componentLocator = componentLocator;
        this.artifactDeclaration = artifactDeclaration;
    }

    public ExtensionModel getExtensionModel(ElementDeclaration declaration) {
        return this.findExtension(declaration).orElseThrow(() -> new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)"There is no extensionModel for extension: %s", (Object[])new Object[]{declaration.getDeclaringExtension()})));
    }

    public Optional<ExtensionModel> findExtension(ElementDeclaration declaration) {
        return this.extensionManager.getExtension(declaration.getDeclaringExtension());
    }

    public <T> Class<T> getParameterClass(ParameterModel parameterModel, ElementDeclaration containerDeclaration) {
        return JavaTypeUtils.getType((MetadataType)parameterModel.getType(), (ClassLoader)MuleExtensionUtils.getClassLoader((ExtensionModel)this.getExtensionModel(containerDeclaration)));
    }

    public <T extends ParameterizedModel & EnrichableModel> Optional<T> findModel(ExtensionModel extensionModel, ElementDeclaration elementDeclaration) {
        return ArtifactHelperUtils.findModel(extensionModel, (IdentifiableElementDeclaration)elementDeclaration);
    }

    public Optional<? extends ComponentModel> findComponentModel(ExtensionModel extensionModel, ComponentElementDeclaration<?> componentDeclaration) {
        return this.findModel(extensionModel, (ElementDeclaration)componentDeclaration).filter(m -> m instanceof ComponentModel).map(m -> (ComponentModel)m);
    }

    public boolean hasParameterOfType(ComponentModel componentModel, StereotypeModel referenceStereotype) {
        return componentModel.getAllParameterModels().stream().filter(paramModel -> paramModel.getAllowedStereotypes().stream().anyMatch(allowed -> allowed.isAssignableTo(referenceStereotype))).findAny().isPresent();
    }

    public Optional<ConfigurationElementDeclaration> findConfigurationDeclaration(final String configName) {
        final Reference configDeclaration = new Reference();
        GlobalElementDeclarationVisitor visitor = new GlobalElementDeclarationVisitor(){

            public void visit(ConfigurationElementDeclaration declaration) {
                if (declaration.getRefName().equals(configName)) {
                    configDeclaration.set((Object)declaration);
                }
            }
        };
        this.artifactDeclaration.getGlobalElements().forEach(gld -> gld.accept(visitor));
        return Optional.ofNullable((ConfigurationElementDeclaration)configDeclaration.get());
    }

    private Optional<ConfigurationProvider> findConfigurationProvider(String configName) {
        return this.findConfigurationDeclaration(configName).map(ced -> Location.builder().globalName(ced.getRefName()).build()).flatMap(cloc -> this.componentLocator.find(cloc)).filter(cp -> cp instanceof ConfigurationProvider).map(cp -> (ConfigurationProvider)cp);
    }

    public Optional<ConfigurationInstance> getConfigurationInstance(String configName) {
        return this.findConfigurationProvider(configName).map(cp -> {
            CoreEvent fakeEvent = NullEventFactory.getNullEvent();
            try {
                ConfigurationInstance configurationInstance = cp.get((Event)fakeEvent);
                return configurationInstance;
            }
            finally {
                if (fakeEvent != null) {
                    ((BaseEventContext)fakeEvent.getContext()).success();
                }
            }
        });
    }

    public List<String> getExtensions() {
        return this.extensionManager.getExtensions().stream().map(extensionModel -> extensionModel.getName()).collect(Collectors.toList());
    }
}

