/*
 * Decompiled with CFR 0.152.
 */
package org.mule.apache.xerces.impl.xs.util;

import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.eclipse.wst.xml.xpath2.processor.ResultSequence;
import org.eclipse.wst.xml.xpath2.processor.ResultSequenceFactory;
import org.eclipse.wst.xml.xpath2.processor.internal.types.AnyType;
import org.mule.apache.xerces.impl.Constants;
import org.mule.apache.xerces.impl.XMLErrorReporter;
import org.mule.apache.xerces.impl.dv.InvalidDatatypeValueException;
import org.mule.apache.xerces.impl.dv.ValidatedInfo;
import org.mule.apache.xerces.impl.dv.ValidationContext;
import org.mule.apache.xerces.impl.dv.XSSimpleType;
import org.mule.apache.xerces.impl.dv.xs.TypeValidatorHelper;
import org.mule.apache.xerces.impl.dv.xs.XSSimpleTypeDecl;
import org.mule.apache.xerces.impl.validation.ValidationState;
import org.mule.apache.xerces.impl.xs.SchemaSymbols;
import org.mule.apache.xerces.impl.xs.XSComplexTypeDecl;
import org.mule.apache.xerces.impl.xs.alternative.XSTypeAlternativeImpl;
import org.mule.apache.xerces.impl.xs.util.XSObjectListImpl;
import org.mule.apache.xerces.util.XMLChar;
import org.mule.apache.xerces.xni.NamespaceContext;
import org.mule.apache.xerces.xs.XSComplexTypeDefinition;
import org.mule.apache.xerces.xs.XSMultiValueFacet;
import org.mule.apache.xerces.xs.XSObjectList;
import org.mule.apache.xerces.xs.XSSimpleTypeDefinition;
import org.mule.apache.xerces.xs.XSTypeDefinition;

public class XS11TypeHelper {
    private XS11TypeHelper() {
    }

    public static boolean isSchemaTypesIdentical(XSTypeDefinition typeDefn1, XSTypeDefinition typeDefn2) {
        boolean typesIdentical = false;
        String type1Name = typeDefn1.getName();
        String type2Name = typeDefn2.getName();
        if ("anyType".equals(type1Name) && "anyType".equals(type2Name) || "anySimpleType".equals(type1Name) && "anySimpleType".equals(type2Name)) {
            typesIdentical = true;
        }
        if (!typesIdentical && XS11TypeHelper.isURIEqual(typeDefn1.getNamespace(), typeDefn2.getNamespace()) && (type1Name == null && type2Name == null || type1Name != null && type1Name.equals(type2Name) && XS11TypeHelper.isSchemaTypesIdentical(typeDefn1.getBaseType(), typeDefn2.getBaseType()))) {
            typesIdentical = true;
        }
        return typesIdentical;
    }

    public static boolean isURIEqual(String uri1, String uri2) {
        return uri1 == uri2 || uri1 != null && uri1.equals(uri2);
    }

    public static boolean isAtomicStrValueValidForSTUnion(XSObjectList memberTypes, String content, ValidatedInfo validatedInfo, short schemaVersion) {
        boolean isValueValid = false;
        for (int memTypeIdx = 0; memTypeIdx < memberTypes.getLength(); ++memTypeIdx) {
            XSSimpleType simpleTypeDv = (XSSimpleType)memberTypes.item(memTypeIdx);
            if (!SchemaSymbols.URI_SCHEMAFORSCHEMA.equals(simpleTypeDv.getNamespace()) || !XS11TypeHelper.isStrValueValidForASimpleType(content, simpleTypeDv, schemaVersion)) continue;
            isValueValid = true;
            validatedInfo.memberType = simpleTypeDv;
            break;
        }
        return isValueValid;
    }

    public static boolean isStrValueValidForASimpleType(String value, XSSimpleType simplType, short schemaVersion) {
        boolean isStrValueValid = true;
        try {
            ValidatedInfo validatedInfo = new ValidatedInfo();
            ValidationState validationState = new ValidationState();
            validationState.setTypeValidatorHelper(TypeValidatorHelper.getInstance(schemaVersion));
            simplType.validate(value, (ValidationContext)validationState, validatedInfo);
        }
        catch (InvalidDatatypeValueException ex) {
            isStrValueValid = false;
        }
        return isStrValueValid;
    }

    public static void validateQNameValue(String qNameStr, NamespaceContext namespaceContext, XMLErrorReporter errorReporter) {
        String[] parsedQname = XS11TypeHelper.parseQnameString(qNameStr);
        String prefix = parsedQname[0];
        String localpart = parsedQname[1];
        if (prefix.length() > 0 && !XMLChar.isValidNCName(prefix) || !XMLChar.isValidNCName(localpart)) {
            errorReporter.reportError("http://www.w3.org/TR/xml-schema-1", "cvc-datatype-valid.1.2.1", new Object[]{qNameStr, "QName"}, (short)1);
        }
        String uri = namespaceContext.getURI(prefix.intern());
        if (prefix.length() > 0 && uri == null) {
            errorReporter.reportError("http://www.w3.org/TR/xml-schema-1", "UndeclaredPrefix", new Object[]{qNameStr, prefix}, (short)1);
        }
    }

    private static String[] parseQnameString(String qNameStr) {
        String localpart;
        String prefix;
        String[] parsedQName = new String[2];
        int colonptr = qNameStr.indexOf(58);
        if (colonptr > 0) {
            prefix = qNameStr.substring(0, colonptr);
            localpart = qNameStr.substring(colonptr + 1);
        } else {
            prefix = SchemaSymbols.EMPTY_STRING;
            localpart = qNameStr;
        }
        parsedQName[0] = prefix;
        parsedQName[1] = localpart;
        return parsedQName;
    }

    public static Vector getAssertsFromSimpleType(XSSimpleTypeDefinition simplType) {
        Vector simpleTypeAsserts = new Vector();
        XSObjectListImpl facetList = (XSObjectListImpl)simplType.getMultiValueFacets();
        for (int facetIdx = 0; facetIdx < facetList.getLength(); ++facetIdx) {
            XSMultiValueFacet facet = (XSMultiValueFacet)facetList.item(facetIdx);
            if (facet.getFacetKind() != 16384) continue;
            simpleTypeAsserts = facet.getAsserts();
        }
        return simpleTypeAsserts;
    }

    public static boolean simpleTypeHasAsserts(XSSimpleTypeDefinition simpleType) {
        boolean simpleTypehasAsserts = false;
        XSObjectList simpleTypeFacets = simpleType.getMultiValueFacets();
        int simpleTypeFacetsLength = simpleTypeFacets.getLength();
        for (int facetIdx = 0; facetIdx < simpleTypeFacetsLength; ++facetIdx) {
            XSMultiValueFacet facet = (XSMultiValueFacet)simpleTypeFacets.item(facetIdx);
            if (facet.getFacetKind() != 16384 || facet.getAsserts().size() <= 0) continue;
            simpleTypehasAsserts = true;
            break;
        }
        return simpleTypehasAsserts;
    }

    public static boolean isListContainsType(List typeList, XSTypeDefinition targetType) {
        boolean typeExists = false;
        Iterator iter = typeList.iterator();
        while (iter.hasNext()) {
            if (!XS11TypeHelper.isSchemaTypesIdentical((XSTypeDefinition)iter.next(), targetType)) continue;
            typeExists = true;
            break;
        }
        return typeExists;
    }

    public static boolean isComplexTypeDerivedFromSTList(XSComplexTypeDefinition complexTypeDef, short derivationMethod) {
        XSTypeDefinition baseType = complexTypeDef.getBaseType();
        return complexTypeDef.getDerivationMethod() == derivationMethod && baseType instanceof XSSimpleTypeDefinition && ((XSSimpleTypeDefinition)baseType).getVariety() == 2;
    }

    public static String getSchemaTypeName(XSTypeDefinition typeDefn) {
        String typeNameStr = "";
        typeNameStr = typeDefn instanceof XSSimpleTypeDefinition ? ((XSSimpleTypeDecl)typeDefn).getTypeName() : ((XSComplexTypeDecl)typeDefn).getTypeName();
        return typeNameStr;
    }

    public static boolean isSpecialSimpleType(XSSimpleType simpleType) {
        boolean isSpecialSimpleType = false;
        String typeName = simpleType.getName();
        if (Constants.NS_XMLSCHEMA.equals(simpleType.getNamespace()) && ("anyAtomicType".equals(typeName) || "anySimpleType".equals(typeName))) {
            isSpecialSimpleType = true;
        }
        return isSpecialSimpleType;
    }

    public static ResultSequence getXPath2ResultSequence(List xdmItems) {
        ResultSequence xpath2Seq = ResultSequenceFactory.create_new();
        Iterator iter = xdmItems.iterator();
        while (iter.hasNext()) {
            xpath2Seq.add((AnyType)iter.next());
        }
        return xpath2Seq;
    }

    public static boolean isTypeTablesComparable(XSTypeAlternativeImpl[] typeTable1, XSTypeAlternativeImpl[] typeTable2) {
        boolean typeTablesComparable = true;
        if (typeTable1 == null && typeTable2 == null) {
            typeTablesComparable = false;
        }
        return typeTablesComparable;
    }
}

