/*
 * Decompiled with CFR 0.152.
 */
package jcifs.smb;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import jcifs.Address;
import jcifs.CIFSContext;
import jcifs.CIFSException;
import jcifs.SmbTransport;
import jcifs.SmbTransportPool;
import jcifs.smb.SmbException;
import jcifs.smb.SmbSessionInternal;
import jcifs.smb.SmbTransportImpl;
import jcifs.smb.SmbTransportInternal;
import jcifs.smb.SmbTreeInternal;
import jcifs.util.transport.TransportException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SmbTransportPoolImpl
implements SmbTransportPool {
    private static final Logger log = LoggerFactory.getLogger(SmbTransportPoolImpl.class);
    private final List<SmbTransportImpl> connections = new LinkedList<SmbTransportImpl>();
    private final List<SmbTransportImpl> nonPooledConnections = new LinkedList<SmbTransportImpl>();
    private final ConcurrentLinkedQueue<SmbTransportImpl> toRemove = new ConcurrentLinkedQueue();
    final Map<String, Integer> failCounts = new ConcurrentHashMap<String, Integer>();

    @Override
    public SmbTransportImpl getSmbTransport(CIFSContext tc, Address address, int port, boolean nonPooled) {
        return this.getSmbTransport(tc, address, port, tc.getConfig().getLocalAddr(), tc.getConfig().getLocalPort(), null, nonPooled);
    }

    @Override
    public SmbTransportImpl getSmbTransport(CIFSContext tc, Address address, int port, boolean nonPooled, boolean forceSigning) {
        return this.getSmbTransport(tc, address, port, tc.getConfig().getLocalAddr(), tc.getConfig().getLocalPort(), null, nonPooled, forceSigning);
    }

    @Override
    public SmbTransportImpl getSmbTransport(CIFSContext tc, Address address, int port, InetAddress localAddr, int localPort, String hostName, boolean nonPooled) {
        return this.getSmbTransport(tc, address, port, localAddr, localPort, hostName, nonPooled, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SmbTransportImpl getSmbTransport(CIFSContext tc, Address address, int port, InetAddress localAddr, int localPort, String hostName, boolean nonPooled, boolean forceSigning) {
        if (port <= 0) {
            port = 445;
        }
        List<SmbTransportImpl> list = this.connections;
        synchronized (list) {
            SmbTransportImpl existing;
            this.cleanup();
            if (log.isTraceEnabled()) {
                log.trace("Exclusive " + nonPooled + " enforced signing " + forceSigning);
            }
            if (!nonPooled && tc.getConfig().getSessionLimit() != 1 && (existing = this.findConnection(tc, address, port, localAddr, localPort, hostName, forceSigning, false)) != null) {
                return existing;
            }
            SmbTransportImpl conn = new SmbTransportImpl(tc, address, port, localAddr, localPort, forceSigning);
            if (log.isDebugEnabled()) {
                log.debug("New transport connection " + conn);
            }
            if (nonPooled) {
                this.nonPooledConnections.add(conn);
            } else {
                this.connections.add(0, conn);
            }
            return conn;
        }
    }

    private SmbTransportImpl findConnection(CIFSContext tc, Address address, int port, InetAddress localAddr, int localPort, String hostName, boolean forceSigning, boolean connectedOnly) {
        for (SmbTransportImpl conn : this.connections) {
            block7: {
                if (!conn.matches(address, port, localAddr, localPort, hostName) || tc.getConfig().getSessionLimit() != 0 && conn.getNumSessions() >= tc.getConfig().getSessionLimit()) continue;
                try {
                    if (conn.isFailed() || connectedOnly && conn.isDisconnected()) continue;
                    if (forceSigning && !conn.isSigningEnforced()) {
                        if (!log.isTraceEnabled()) continue;
                        log.debug("Cannot reuse, signing enforced but connection does not have it enabled " + conn);
                        continue;
                    }
                    if (!forceSigning && !tc.getConfig().isSigningEnforced() && conn.isSigningEnforced() && !conn.getNegotiateResponse().isSigningRequired()) {
                        if (!log.isTraceEnabled()) continue;
                        log.debug("Cannot reuse, signing enforced on connection " + conn);
                        continue;
                    }
                    if (!conn.getNegotiateResponse().canReuse(tc, forceSigning)) {
                        if (!log.isTraceEnabled()) continue;
                        log.trace("Cannot reuse, different config " + conn);
                    }
                    break block7;
                }
                catch (CIFSException e) {
                    log.debug("Error while checking for reuse", (Throwable)e);
                }
                continue;
            }
            if (log.isTraceEnabled()) {
                log.trace("Reusing transport connection " + conn);
            }
            return conn.acquire();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public SmbTransportImpl getSmbTransport(CIFSContext tf, String name, int port, boolean exclusive, boolean forceSigning) throws IOException {
        Address[] addrs = tf.getNameServiceClient().getAllByName(name, true);
        if (addrs == null) throw new UnknownHostException(name);
        if (addrs.length == 0) {
            throw new UnknownHostException(name);
        }
        Arrays.sort(addrs, new Comparator<Address>(){

            @Override
            public int compare(Address o1, Address o2) {
                Integer fail1 = SmbTransportPoolImpl.this.failCounts.get(o1.getHostAddress());
                Integer fail2 = SmbTransportPoolImpl.this.failCounts.get(o2.getHostAddress());
                if (fail1 == null) {
                    fail1 = 0;
                }
                if (fail2 == null) {
                    fail2 = 0;
                }
                return Integer.compare(fail1, fail2);
            }
        });
        List<SmbTransportImpl> list = this.connections;
        synchronized (list) {
            for (Address addr : addrs) {
                SmbTransportImpl found = this.findConnection(tf, addr, port, tf.getConfig().getLocalAddr(), tf.getConfig().getLocalPort(), name, forceSigning, true);
                if (found == null) continue;
                return found;
            }
        }
        IOException ex = null;
        Address[] addressArray = addrs;
        int n = addressArray.length;
        int n2 = 0;
        while (true) {
            Address addr;
            if (n2 >= n) {
                if (ex == null) throw new TransportException("All connection attempts failed");
                throw ex;
            }
            addr = addressArray[n2];
            if (log.isDebugEnabled()) {
                log.debug("Trying address {}", (Object)addr);
            }
            try (SmbTransportImpl trans = this.getSmbTransport(tf, addr, port, exclusive, forceSigning).unwrap(SmbTransportImpl.class);){
                try {
                    trans.ensureConnected();
                }
                catch (IOException e2332) {
                    this.removeTransport(trans);
                    throw e2332;
                }
                SmbTransportImpl e2332 = trans.acquire();
                return e2332;
            }
            catch (IOException e) {
                String hostAddress = addr.getHostAddress();
                Integer failCount = this.failCounts.get(hostAddress);
                if (failCount == null) {
                    this.failCounts.put(hostAddress, 1);
                } else {
                    this.failCounts.put(hostAddress, failCount + 1);
                }
                ex = e;
                ++n2;
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(SmbTransport trans) {
        List<SmbTransportImpl> list = this.connections;
        synchronized (list) {
            this.cleanup();
            return this.connections.contains(trans);
        }
    }

    @Override
    public void removeTransport(SmbTransport trans) {
        if (log.isDebugEnabled()) {
            log.debug("Scheduling transport connection for removal " + trans + " (" + System.identityHashCode(trans) + ")");
        }
        this.toRemove.add((SmbTransportImpl)trans);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanup() {
        List<SmbTransportImpl> list = this.connections;
        synchronized (list) {
            SmbTransportImpl trans;
            while ((trans = this.toRemove.poll()) != null) {
                if (log.isDebugEnabled()) {
                    log.debug("Removing transport connection " + trans + " (" + System.identityHashCode(trans) + ")");
                }
                this.connections.remove(trans);
                this.nonPooledConnections.remove(trans);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean close() throws CIFSException {
        LinkedList<SmbTransportImpl> toClose;
        boolean inUse = false;
        List<SmbTransportImpl> list = this.connections;
        synchronized (list) {
            this.cleanup();
            log.debug("Closing pool");
            toClose = new LinkedList<SmbTransportImpl>(this.connections);
            toClose.addAll(this.nonPooledConnections);
            this.connections.clear();
            this.nonPooledConnections.clear();
        }
        for (SmbTransportImpl conn : toClose) {
            try {
                inUse |= conn.disconnect(false, false);
            }
            catch (IOException e) {
                log.warn("Failed to close connection", (Throwable)e);
            }
        }
        list = this.connections;
        synchronized (list) {
            this.cleanup();
        }
        return inUse;
    }

    @Override
    public byte[] getChallenge(CIFSContext tf, Address dc) throws SmbException {
        return this.getChallenge(tf, dc, 0);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public byte[] getChallenge(CIFSContext tf, Address dc, int port) throws SmbException {
        try (SmbTransportInternal trans = tf.getTransportPool().getSmbTransport(tf, dc, port, false, !tf.getCredentials().isAnonymous() && tf.getConfig().isIpcSigningEnforced()).unwrap(SmbTransportInternal.class);){
            trans.ensureConnected();
            byte[] byArray = trans.getServerEncryptionKey();
            return byArray;
        }
        catch (SmbException e) {
            throw e;
        }
        catch (IOException e) {
            throw new SmbException("Connection failed", (Throwable)e);
        }
    }

    @Override
    public void logon(CIFSContext tf, Address dc) throws SmbException {
        this.logon(tf, dc, 0);
    }

    @Override
    @Deprecated
    public void logon(CIFSContext tf, Address dc, int port) throws SmbException {
        try (SmbTransportInternal smbTransport = tf.getTransportPool().getSmbTransport(tf, dc, port, false, tf.getConfig().isIpcSigningEnforced()).unwrap(SmbTransportInternal.class);
             SmbSessionInternal smbSession = smbTransport.getSmbSession(tf, dc.getHostName(), null).unwrap(SmbSessionInternal.class);
             SmbTreeInternal tree = smbSession.getSmbTree(tf.getConfig().getLogonShare(), null).unwrap(SmbTreeInternal.class);){
            tree.connectLogon(tf);
        }
    }
}

