/*
 * Decompiled with CFR 0.152.
 */
package jcifs.internal.smb1.trans2;

import jcifs.Configuration;
import jcifs.internal.fscc.FileBasicInfo;
import jcifs.internal.fscc.FileInformation;
import jcifs.internal.smb1.trans.SmbComTransaction;
import jcifs.internal.smb1.trans2.Trans2QueryPathInformation;
import jcifs.internal.util.SMBUtil;

public class Trans2SetFileInformation
extends SmbComTransaction {
    private final int fid;
    private final FileInformation info;

    public Trans2SetFileInformation(Configuration config, int fid, FileInformation info) {
        super(config, (byte)50, (byte)8);
        this.fid = fid;
        this.info = info;
        this.maxParameterCount = 6;
        this.maxDataCount = 0;
        this.maxSetupCount = 0;
    }

    public Trans2SetFileInformation(Configuration config, int fid, int attributes, long createTime, long lastWriteTime, long lastAccessTime) {
        this(config, fid, new FileBasicInfo(createTime, lastAccessTime, lastWriteTime, 0L, attributes | 0x80));
    }

    @Override
    protected int writeSetupWireFormat(byte[] dst, int dstIndex) {
        dst[dstIndex++] = this.getSubCommand();
        dst[dstIndex++] = 0;
        return 2;
    }

    @Override
    protected int writeParametersWireFormat(byte[] dst, int dstIndex) {
        int start = dstIndex;
        SMBUtil.writeInt2(this.fid, dst, dstIndex);
        SMBUtil.writeInt2(Trans2QueryPathInformation.mapInformationLevel(this.info.getFileInformationLevel()), dst, dstIndex += 2);
        SMBUtil.writeInt2(0L, dst, dstIndex += 2);
        return (dstIndex += 2) - start;
    }

    @Override
    protected int writeDataWireFormat(byte[] dst, int dstIndex) {
        int start = dstIndex;
        dstIndex += this.info.encode(dst, dstIndex);
        SMBUtil.writeInt8(0L, dst, dstIndex);
        return (dstIndex += 6) - start;
    }

    @Override
    protected int readSetupWireFormat(byte[] buffer, int bufferIndex, int len) {
        return 0;
    }

    @Override
    protected int readParametersWireFormat(byte[] buffer, int bufferIndex, int len) {
        return 0;
    }

    @Override
    protected int readDataWireFormat(byte[] buffer, int bufferIndex, int len) {
        return 0;
    }

    @Override
    public String toString() {
        return new String("Trans2SetFileInformation[" + super.toString() + ",fid=" + this.fid + "]");
    }
}

