/*
 * Decompiled with CFR 0.152.
 */
package org.mule.metadata.api.builder;

import org.mule.metadata.api.annotation.TypeAnnotation;
import org.mule.metadata.api.builder.AbstractBuilder;
import org.mule.metadata.api.builder.TypeBuilder;
import org.mule.metadata.api.builder.WithAnnotation;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.ReferenceResolver;
import org.mule.metadata.api.model.ReferenceType;
import org.mule.metadata.api.model.impl.DefaultReferenceType;

public class ReferenceTypeBuilder
extends AbstractBuilder<ReferenceType>
implements TypeBuilder<ReferenceType>,
WithAnnotation<ReferenceTypeBuilder> {
    private ReferenceResolver resolver;
    private String name;

    protected ReferenceTypeBuilder(MetadataFormat format) {
        super(format);
    }

    public ReferenceTypeBuilder withResolver(ReferenceResolver resolver) {
        this.resolver = resolver;
        return this;
    }

    public ReferenceTypeBuilder withName(String name) {
        this.name = name;
        return this;
    }

    @Override
    public ReferenceType build() {
        if (this.resolver == null) {
            throw new IllegalStateException("Resolver can not be null, use withResolver to specify the type resolver.");
        }
        if (this.name == null) {
            throw new IllegalStateException("Name can not be null, use withName to specify the type name.");
        }
        return new DefaultReferenceType(this.resolver, this.name, this.format, this.annotations);
    }

    @Override
    public ReferenceTypeBuilder with(TypeAnnotation typeAnnotation) {
        this.addExtension(typeAnnotation);
        return this;
    }
}

