/*
 * Decompiled with CFR 0.152.
 */
package org.mule.maven.client.internal.dependency;

import org.eclipse.aether.collection.DependencyCollectionContext;
import org.eclipse.aether.collection.DependencySelector;
import org.eclipse.aether.graph.Dependency;

public class PluginAwareExclusionDependencySelector
implements DependencySelector {
    private DependencySelector delegateSelector;
    private boolean isPluginContext = false;

    public PluginAwareExclusionDependencySelector(DependencySelector delegateSelector) {
        this.delegateSelector = delegateSelector;
    }

    public PluginAwareExclusionDependencySelector(DependencySelector delegateSelector, boolean isPluginContext) {
        this.delegateSelector = delegateSelector;
        this.isPluginContext = isPluginContext;
    }

    public boolean selectDependency(Dependency dependency) {
        if (this.isPluginContext && !"mule-plugin".equals(dependency.getArtifact().getClassifier())) {
            return true;
        }
        return this.delegateSelector.selectDependency(dependency);
    }

    public DependencySelector deriveChildSelector(DependencyCollectionContext context) {
        boolean isPluginContext = context.getDependency() != null && "mule-plugin".equals(context.getDependency().getArtifact().getClassifier());
        DependencySelector dependencySelector = this.delegateSelector.deriveChildSelector(context);
        if (dependencySelector.equals(this.delegateSelector) && isPluginContext == this.isPluginContext) {
            return this;
        }
        return new PluginAwareExclusionDependencySelector(dependencySelector, isPluginContext);
    }

    public int hashCode() {
        return this.delegateSelector.hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof PluginAwareExclusionDependencySelector)) {
            return false;
        }
        return this.delegateSelector.equals(((PluginAwareExclusionDependencySelector)obj).delegateSelector);
    }
}

