/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.tracer.impl;

import java.util.function.Supplier;
import org.slf4j.Logger;

public class SafeExecutionUtils {
    private SafeExecutionUtils() {
    }

    public static <T> T safeExecuteWithDefaultOnThrowable(Supplier<T> resultSupplier, T onFailReturnValue, String loggingMessage, boolean propagateExceptions, Logger logger) {
        try {
            return resultSupplier.get();
        }
        catch (Throwable e) {
            if (propagateExceptions) {
                throw e;
            }
            if (logger.isWarnEnabled()) {
                logger.warn(loggingMessage, e);
            }
            return onFailReturnValue;
        }
    }

    public static void safeExecute(Runnable toExecute, String loggingMessage, boolean propagateExceptions, Logger logger) {
        block3: {
            try {
                toExecute.run();
            }
            catch (Throwable e) {
                if (propagateExceptions) {
                    throw e;
                }
                if (!logger.isWarnEnabled()) break block3;
                logger.warn(loggingMessage, e);
            }
        }
    }
}

