/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.metadata;

import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.mule.metadata.message.api.MessageMetadataType;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.api.meta.model.ComponentModelVisitor;
import org.mule.runtime.api.meta.model.EnrichableModel;
import org.mule.runtime.api.meta.model.HasOutputModel;
import org.mule.runtime.api.meta.model.OutputModel;
import org.mule.runtime.api.meta.model.construct.ConstructModel;
import org.mule.runtime.api.meta.model.deprecated.DeprecationModel;
import org.mule.runtime.api.meta.model.display.DisplayModel;
import org.mule.runtime.api.meta.model.display.LayoutModel;
import org.mule.runtime.api.meta.model.nested.NestedChainModel;
import org.mule.runtime.api.meta.model.nested.NestedComponentModel;
import org.mule.runtime.api.meta.model.nested.NestedRouteModel;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.meta.model.parameter.ParameterGroupModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.meta.model.parameter.ValueProviderModel;
import org.mule.runtime.api.meta.model.source.SourceCallbackModel;
import org.mule.runtime.api.meta.model.source.SourceModel;
import org.mule.runtime.api.metadata.MetadataAttributes;
import org.mule.runtime.api.metadata.MetadataContext;
import org.mule.runtime.api.metadata.MetadataKey;
import org.mule.runtime.api.metadata.MetadataKeysContainer;
import org.mule.runtime.api.metadata.MetadataResolvingException;
import org.mule.runtime.api.metadata.descriptor.BaseInputMetadataDescriptor;
import org.mule.runtime.api.metadata.descriptor.ComponentMetadataDescriptor;
import org.mule.runtime.api.metadata.descriptor.InputMetadataDescriptor;
import org.mule.runtime.api.metadata.descriptor.OutputMetadataDescriptor;
import org.mule.runtime.api.metadata.descriptor.ParameterMetadataDescriptor;
import org.mule.runtime.api.metadata.descriptor.RouterInputMetadataDescriptor;
import org.mule.runtime.api.metadata.descriptor.ScopeInputMetadataDescriptor;
import org.mule.runtime.api.metadata.descriptor.TypeMetadataDescriptor;
import org.mule.runtime.api.metadata.resolving.FailureCode;
import org.mule.runtime.api.metadata.resolving.MetadataFailure;
import org.mule.runtime.api.metadata.resolving.MetadataResult;
import org.mule.runtime.api.util.Reference;
import org.mule.runtime.extension.api.model.ImmutableOutputModel;
import org.mule.runtime.extension.api.model.construct.ImmutableConstructModel;
import org.mule.runtime.extension.api.model.operation.ImmutableOperationModel;
import org.mule.runtime.extension.api.model.parameter.ImmutableParameterGroupModel;
import org.mule.runtime.extension.api.model.parameter.ImmutableParameterModel;
import org.mule.runtime.extension.api.model.source.ImmutableSourceCallbackModel;
import org.mule.runtime.extension.api.model.source.ImmutableSourceModel;
import org.mule.runtime.extension.api.property.MetadataKeyIdModelProperty;
import org.mule.runtime.extension.api.property.MetadataKeyPartModelProperty;
import org.mule.runtime.extension.api.util.ExtensionModelUtils;
import org.mule.runtime.module.extension.api.runtime.resolver.ParameterValueResolver;
import org.mule.runtime.module.extension.api.tooling.metadata.MetadataMediator;
import org.mule.runtime.module.extension.internal.metadata.MetadataInputDelegate;
import org.mule.runtime.module.extension.internal.metadata.MetadataKeyIdObjectResolver;
import org.mule.runtime.module.extension.internal.metadata.MetadataKeysDelegate;
import org.mule.runtime.module.extension.internal.metadata.MetadataOutputDelegate;
import org.mule.runtime.module.extension.internal.util.ReflectionCache;

public final class DefaultMetadataMediator<T extends ComponentModel>
implements MetadataMediator {
    protected final T component;
    private final ReflectionCache reflectionCache;
    private final List<ParameterModel> metadataKeyParts;
    private final MetadataKeysDelegate keysDelegate;
    private final MetadataOutputDelegate outputDelegate;
    private final MetadataInputDelegate inputDelegate;
    private final MetadataKeyIdObjectResolver keyIdObjectResolver;
    private final Optional<MetadataInputDelegate> successCallbackInputDelegate;
    private final Optional<MetadataInputDelegate> errorCallbackInputDelegate;
    private String keyContainerName = null;

    public DefaultMetadataMediator(T componentModel, ReflectionCache reflectionCache) {
        this.component = componentModel;
        this.reflectionCache = reflectionCache;
        this.metadataKeyParts = this.getMetadataKeyParts((ComponentModel)componentModel);
        this.keysDelegate = new MetadataKeysDelegate((ComponentModel)componentModel, this.metadataKeyParts);
        this.keyIdObjectResolver = new MetadataKeyIdObjectResolver((ComponentModel)this.component);
        this.outputDelegate = new MetadataOutputDelegate((EnrichableModel)componentModel);
        this.inputDelegate = new MetadataInputDelegate((EnrichableModel)componentModel);
        if (componentModel instanceof SourceModel) {
            this.successCallbackInputDelegate = ((SourceModel)componentModel).getSuccessCallback().map(successCallbackModel -> new MetadataInputDelegate((EnrichableModel)successCallbackModel));
            this.errorCallbackInputDelegate = ((SourceModel)componentModel).getErrorCallback().map(errorCallbackModel -> new MetadataInputDelegate((EnrichableModel)errorCallbackModel));
        } else {
            this.successCallbackInputDelegate = Optional.empty();
            this.errorCallbackInputDelegate = Optional.empty();
        }
        componentModel.getModelProperty(MetadataKeyIdModelProperty.class).ifPresent(keyIdMP -> {
            this.keyContainerName = keyIdMP.getParameterName();
        });
    }

    public MetadataResult<MetadataKeysContainer> getMetadataKeys(MetadataContext context) {
        return this.keysDelegate.getMetadataKeys(context, this.reflectionCache);
    }

    @Override
    public MetadataResult<MetadataKeysContainer> getMetadataKeys(MetadataContext context, ParameterValueResolver metadataKeyResolver) {
        MetadataResult<Object> keyValueResult = this.getMetadataKeyObjectValue(metadataKeyResolver);
        if (!keyValueResult.isSuccess()) {
            return keyValueResult;
        }
        return this.keysDelegate.getMetadataKeys(context, keyValueResult.get(), this.reflectionCache);
    }

    @Override
    public MetadataResult<MetadataKeysContainer> getMetadataKeys(MetadataContext context, MetadataKey partialKey) {
        try {
            Object resolvedKey = this.keyIdObjectResolver.resolveWithPartialKey(partialKey);
            return this.keysDelegate.getMetadataKeys(context, resolvedKey, this.reflectionCache);
        }
        catch (MetadataResolvingException e) {
            return MetadataResult.failure((MetadataFailure[])new MetadataFailure[]{MetadataFailure.Builder.newFailure((Exception)((Object)e)).onKeys()});
        }
    }

    public MetadataResult<ComponentMetadataDescriptor<T>> getMetadata(MetadataContext context, MetadataKey key) {
        try {
            Object resolvedKey = this.keyIdObjectResolver.resolve(key);
            return this.getMetadata(context, resolvedKey, MetadataAttributes.builder().withKey(key));
        }
        catch (MetadataResolvingException e) {
            return MetadataResult.failure((MetadataFailure[])new MetadataFailure[]{MetadataFailure.Builder.newFailure((Exception)((Object)e)).onComponent()});
        }
    }

    public MetadataResult<ComponentMetadataDescriptor<T>> getMetadata(MetadataContext context, ParameterValueResolver metadataKeyResolver) {
        try {
            MetadataResult<Object> keyValueResult = this.getMetadataKeyObjectValue(metadataKeyResolver);
            if (!keyValueResult.isSuccess()) {
                return keyValueResult;
            }
            Object keyValue = keyValueResult.get();
            if (keyValue == null && this.keyIdObjectResolver.isKeyRequired()) {
                return MetadataResult.failure((MetadataFailure[])new MetadataFailure[]{MetadataFailure.Builder.newFailure().withFailureCode(FailureCode.INVALID_METADATA_KEY).withMessage("MetadataKey resolved to null").onComponent()});
            }
            MetadataAttributes.MetadataAttributesBuilder builder = MetadataAttributes.builder();
            if (!this.keyIdObjectResolver.isKeyLess()) {
                builder.withKey(this.keyIdObjectResolver.reconstructKeyFromType(keyValue, this.reflectionCache));
            }
            return this.getMetadata(context, keyValue, builder);
        }
        catch (MetadataResolvingException e) {
            return MetadataResult.failure((MetadataFailure[])new MetadataFailure[]{MetadataFailure.Builder.newFailure((Exception)((Object)e)).onComponent()});
        }
    }

    @Override
    public MetadataResult<ScopeInputMetadataDescriptor> getScopeInputMetadata(MetadataContext context, MetadataKey key, Supplier<MessageMetadataType> scopeInputMessageType) {
        if (!ExtensionModelUtils.isScope(this.component)) {
            return MetadataResult.failure((MetadataFailure[])new MetadataFailure[]{MetadataFailure.Builder.newFailure().withMessage("The given component is not a scope").onComponent()});
        }
        MetadataResult<InputMetadataDescriptor> inputMetadata = this.getInputMetadata(context, key);
        if (!inputMetadata.isSuccess()) {
            return inputMetadata;
        }
        MetadataResult<MessageMetadataType> scopeChainInputType = this.inputDelegate.getScopeChainInputType(context, scopeInputMessageType, (InputMetadataDescriptor)inputMetadata.get());
        if (scopeChainInputType.isSuccess()) {
            return MetadataResult.success((Object)((ScopeInputMetadataDescriptor.ScopeInputMetadataDescriptorBuilder)ScopeInputMetadataDescriptor.builder().withParameters(((InputMetadataDescriptor)inputMetadata.get()).getAllParameters())).withChainInputMessageType((MessageMetadataType)scopeChainInputType.get()).build());
        }
        return scopeChainInputType;
    }

    @Override
    public MetadataResult<RouterInputMetadataDescriptor> getRouterInputMetadata(MetadataContext context, MetadataKey key, Supplier<MessageMetadataType> routerInputMessageType) {
        if (!ExtensionModelUtils.isRouter(this.component)) {
            return MetadataResult.failure((MetadataFailure[])new MetadataFailure[]{MetadataFailure.Builder.newFailure().withMessage("The given component is not a router").onComponent()});
        }
        MetadataResult<InputMetadataDescriptor> inputMetadata = this.getInputMetadata(context, key);
        if (!inputMetadata.isSuccess()) {
            return inputMetadata;
        }
        MetadataResult<Map<String, MessageMetadataType>> routesInputTypes = this.inputDelegate.getRoutesChainInputType(context, routerInputMessageType, (InputMetadataDescriptor)inputMetadata.get());
        if (routesInputTypes.isSuccess()) {
            return MetadataResult.success((Object)((RouterInputMetadataDescriptor.RouterInputMetadataDescriptorBuilder)RouterInputMetadataDescriptor.builder().withParameters(((InputMetadataDescriptor)inputMetadata.get()).getAllParameters())).withRoutesInputMessageTypes((Map)routesInputTypes.get()).build());
        }
        return routesInputTypes;
    }

    @Override
    public MetadataResult<InputMetadataDescriptor> getInputMetadata(MetadataContext context, MetadataKey key) {
        try {
            Object resolvedKey = this.keyIdObjectResolver.resolve(key);
            MetadataResult<InputMetadataDescriptor> input = this.inputDelegate.getInputMetadataDescriptors(context, resolvedKey);
            Optional<MetadataResult> successCallbackInput = this.successCallbackInputDelegate.map(successCallbackInputDelegate -> successCallbackInputDelegate.getInputMetadataDescriptors(context, resolvedKey));
            Optional<MetadataResult> errorCallbackInput = this.errorCallbackInputDelegate.map(errorCallbackInputDelegate -> errorCallbackInputDelegate.getInputMetadataDescriptors(context, resolvedKey));
            if (!(!input.isSuccess() || successCallbackInput.isPresent() && !successCallbackInput.get().isSuccess() || errorCallbackInput.isPresent() && !errorCallbackInput.get().isSuccess())) {
                InputMetadataDescriptor.InputMetadataDescriptorBuilder inputMetadataDescriptorBuilder = InputMetadataDescriptor.builder();
                ((InputMetadataDescriptor)input.get()).getAllParameters().forEach((name, parameterMetadataDescriptor) -> inputMetadataDescriptorBuilder.withParameter(name, parameterMetadataDescriptor));
                successCallbackInput.map(MetadataResult::get).ifPresent(successCallbackInputDescriptor -> successCallbackInputDescriptor.getAllParameters().forEach((name, parameterMetadataDescriptor) -> inputMetadataDescriptorBuilder.withParameter(name, parameterMetadataDescriptor)));
                errorCallbackInput.map(MetadataResult::get).ifPresent(errorCallbackInputDescriptor -> errorCallbackInputDescriptor.getAllParameters().forEach((name, parameterMetadataDescriptor) -> inputMetadataDescriptorBuilder.withParameter(name, parameterMetadataDescriptor)));
                return MetadataResult.success((Object)inputMetadataDescriptorBuilder.build());
            }
            ImmutableList failures = ImmutableList.builder().addAll((Iterable)input.getFailures()).addAll((Iterable)successCallbackInput.map(MetadataResult::getFailures).orElse(Collections.emptyList())).addAll((Iterable)errorCallbackInput.map(MetadataResult::getFailures).orElse(Collections.emptyList())).build();
            return MetadataResult.failure((List)failures);
        }
        catch (MetadataResolvingException e) {
            return MetadataResult.failure((MetadataFailure[])new MetadataFailure[]{MetadataFailure.Builder.newFailure((Exception)((Object)e)).onComponent()});
        }
    }

    @Override
    public MetadataResult<OutputMetadataDescriptor> getOutputMetadata(MetadataContext context, MetadataKey key) {
        if (!(this.component instanceof HasOutputModel)) {
            return MetadataResult.failure((MetadataFailure[])new MetadataFailure[]{MetadataFailure.Builder.newFailure().withMessage("The given component has not output definition to be described").onComponent()});
        }
        try {
            Object resolvedKey = this.keyIdObjectResolver.resolve(key);
            return this.outputDelegate.getOutputMetadataDescriptor(context, resolvedKey);
        }
        catch (MetadataResolvingException e) {
            return MetadataResult.failure((MetadataFailure[])new MetadataFailure[]{MetadataFailure.Builder.newFailure((Exception)((Object)e)).onComponent()});
        }
    }

    private MetadataResult<ComponentMetadataDescriptor<T>> getMetadata(MetadataContext context, Object keyValue, MetadataAttributes.MetadataAttributesBuilder attributesBuilder) {
        MetadataResult<OutputMetadataDescriptor> output = this.getOutputMetadataDescriptor(context, keyValue);
        MetadataResult<InputMetadataDescriptor> input = this.inputDelegate.getInputMetadataDescriptors(context, keyValue);
        Optional<MetadataResult> successCallbackInput = this.successCallbackInputDelegate.map(successCallbackInputDelegate -> successCallbackInputDelegate.getInputMetadataDescriptors(context, keyValue));
        Optional<MetadataResult> errorCallbackInput = this.errorCallbackInputDelegate.map(errorCallbackInputDelegate -> errorCallbackInputDelegate.getInputMetadataDescriptors(context, keyValue));
        if (output.isSuccess() && input.isSuccess() && (!successCallbackInput.isPresent() || successCallbackInput.get().isSuccess()) && (!errorCallbackInput.isPresent() || errorCallbackInput.get().isSuccess())) {
            MetadataAttributes metadataAttributes = this.getMetadataAttributes(attributesBuilder, this.outputDelegate, (InputMetadataDescriptor)input.get());
            T model = this.getTypedModel((InputMetadataDescriptor)input.get(), (OutputMetadataDescriptor)output.get(), successCallbackInput.map(MetadataResult::get), errorCallbackInput.map(MetadataResult::get));
            return MetadataResult.success((Object)ComponentMetadataDescriptor.builder(model).withAttributes(metadataAttributes).build());
        }
        ImmutableList failures = ImmutableList.builder().addAll((Iterable)output.getFailures()).addAll((Iterable)input.getFailures()).addAll((Iterable)successCallbackInput.map(MetadataResult::getFailures).orElse(Collections.emptyList())).addAll((Iterable)errorCallbackInput.map(MetadataResult::getFailures).orElse(Collections.emptyList())).build();
        return MetadataResult.failure((Object)ComponentMetadataDescriptor.builder(this.component).build(), (List)failures);
    }

    private MetadataResult<OutputMetadataDescriptor> getOutputMetadataDescriptor(MetadataContext context, Object keyValue) {
        return this.outputDelegate.getOutputMetadataDescriptor(context, keyValue);
    }

    private T getTypedModel(final InputMetadataDescriptor inputMetadataDescriptor, final OutputMetadataDescriptor outputMetadataDescriptor, final Optional<InputMetadataDescriptor> successSourceCallbackInputMetadataDescriptor, final Optional<InputMetadataDescriptor> errorSourceCallbackInputMetadataDescriptor) {
        final Reference typedModel = new Reference();
        this.component.accept(new ComponentModelVisitor(){

            public void visit(ConstructModel constructModel) {
                typedModel.set((Object)new ImmutableConstructModel(constructModel.getName(), constructModel.getDescription(), DefaultMetadataMediator.this.resolveParameterGroupModelType(constructModel.getParameterGroupModels(), inputMetadataDescriptor.getAllParameters()), constructModel.getNestedComponents(), constructModel.allowsTopLevelDeclaration(), (DisplayModel)constructModel.getDisplayModel().orElse(null), constructModel.getErrorModels(), constructModel.getStereotype(), constructModel.getVisibility(), constructModel.getModelProperties(), (DeprecationModel)constructModel.getDeprecationModel().orElse(null)));
            }

            public void visit(OperationModel operationModel) {
                OutputModel typedOutputModel = DefaultMetadataMediator.this.resolveOutputModelType(operationModel.getOutput(), outputMetadataDescriptor.getPayloadMetadata());
                OutputModel typedAttributesModel = DefaultMetadataMediator.this.resolveOutputModelType(operationModel.getOutputAttributes(), outputMetadataDescriptor.getAttributesMetadata());
                typedModel.set((Object)new ImmutableOperationModel(operationModel.getName(), operationModel.getDescription(), DefaultMetadataMediator.this.resolveParameterGroupModelType(operationModel.getParameterGroupModels(), inputMetadataDescriptor.getAllParameters()), operationModel.getNestedComponents(), typedOutputModel, typedAttributesModel, operationModel.isBlocking(), operationModel.getExecutionType(), operationModel.requiresConnection(), operationModel.isTransactional(), operationModel.supportsStreaming(), (DisplayModel)operationModel.getDisplayModel().orElse(null), operationModel.getErrorModels(), operationModel.getStereotype(), operationModel.getVisibility(), operationModel.getModelProperties(), operationModel.getNotificationModels(), (DeprecationModel)operationModel.getDeprecationModel().orElse(null)));
            }

            public void visit(SourceModel sourceModel) {
                OutputModel typedOutputModel = DefaultMetadataMediator.this.resolveOutputModelType(sourceModel.getOutput(), outputMetadataDescriptor.getPayloadMetadata());
                OutputModel typedAttributesModel = DefaultMetadataMediator.this.resolveOutputModelType(sourceModel.getOutputAttributes(), outputMetadataDescriptor.getAttributesMetadata());
                typedModel.set((Object)new ImmutableSourceModel(sourceModel.getName(), sourceModel.getDescription(), sourceModel.hasResponse(), true, DefaultMetadataMediator.this.resolveParameterGroupModelType(sourceModel.getParameterGroupModels(), inputMetadataDescriptor.getAllParameters()), sourceModel.getNestedComponents(), typedOutputModel, typedAttributesModel, DefaultMetadataMediator.this.resolveSourceCallbackType(sourceModel.getSuccessCallback(), successSourceCallbackInputMetadataDescriptor.map(BaseInputMetadataDescriptor::getAllParameters).orElse(Collections.emptyMap())), DefaultMetadataMediator.this.resolveSourceCallbackType(sourceModel.getErrorCallback(), errorSourceCallbackInputMetadataDescriptor.map(BaseInputMetadataDescriptor::getAllParameters).orElse(Collections.emptyMap())), DefaultMetadataMediator.this.resolveSourceCallbackType(sourceModel.getTerminateCallback(), inputMetadataDescriptor.getAllParameters()), sourceModel.requiresConnection(), sourceModel.isTransactional(), sourceModel.supportsStreaming(), (DisplayModel)sourceModel.getDisplayModel().orElse(null), sourceModel.getStereotype(), sourceModel.getErrorModels(), sourceModel.getVisibility(), sourceModel.getModelProperties(), sourceModel.getNotificationModels(), (DeprecationModel)sourceModel.getDeprecationModel().orElse(null)));
            }

            public void visit(NestedComponentModel model) {
            }

            public void visit(NestedChainModel model) {
            }

            public void visit(NestedRouteModel model) {
            }
        });
        return (T)((ComponentModel)typedModel.get());
    }

    private MetadataAttributes getMetadataAttributes(MetadataAttributes.MetadataAttributesBuilder attributesBuilder, MetadataOutputDelegate outputDelegate, InputMetadataDescriptor input) {
        outputDelegate.getCategoryName().ifPresent(arg_0 -> ((MetadataAttributes.MetadataAttributesBuilder)attributesBuilder).withCategoryName(arg_0));
        outputDelegate.getOutputResolver().ifPresent(r -> attributesBuilder.withOutputResolver(r.getResolverName()));
        outputDelegate.getOutputAttributesResolver().ifPresent(r -> attributesBuilder.withOutputAttributesResolver(r.getResolverName()));
        input.getAllParameters().forEach((key, value) -> attributesBuilder.withParameterResolver(key, this.inputDelegate.getParameterResolver((String)key).getResolverName()));
        return attributesBuilder.build();
    }

    private MetadataResult<Object> getMetadataKeyObjectValue(ParameterValueResolver keyValueResolver) {
        try {
            Object keyValue = this.getContainerName().isPresent() ? keyValueResolver.getParameterValue(this.getContainerName().get()) : null;
            return MetadataResult.success(keyValue);
        }
        catch (Exception e) {
            return MetadataResult.failure((MetadataFailure[])new MetadataFailure[]{MetadataFailure.Builder.newFailure((Exception)e).onComponent()});
        }
    }

    private List<ParameterModel> getMetadataKeyParts(ComponentModel componentModel) {
        return componentModel.getAllParameterModels().stream().filter(p -> p.getModelProperty(MetadataKeyPartModelProperty.class).isPresent()).collect(Collectors.toList());
    }

    private Optional<String> getContainerName() {
        return Optional.ofNullable(this.keyContainerName);
    }

    private List<ParameterGroupModel> resolveParameterGroupModelType(List<ParameterGroupModel> untypedParameterGroups, Map<String, ParameterMetadataDescriptor> inputTypeDescriptors) {
        LinkedList<ParameterGroupModel> parameterGroups = new LinkedList<ParameterGroupModel>();
        untypedParameterGroups.forEach(parameterGroup -> {
            LinkedList parameters = new LinkedList();
            parameterGroup.getParameterModels().forEach(parameterModel -> {
                ParameterMetadataDescriptor parameterMetadataDescriptor = (ParameterMetadataDescriptor)inputTypeDescriptors.get(parameterModel.getName());
                ImmutableParameterModel typedParameterModel = new ImmutableParameterModel(parameterModel.getName(), parameterModel.getDescription(), parameterMetadataDescriptor.getType(), parameterMetadataDescriptor.isDynamic(), parameterModel.isRequired(), parameterModel.isOverrideFromConfig(), parameterModel.isComponentId(), parameterModel.getExpressionSupport(), parameterModel.getDefaultValue(), parameterModel.getRole(), parameterModel.getDslConfiguration(), (DisplayModel)parameterModel.getDisplayModel().orElse(null), (LayoutModel)parameterModel.getLayoutModel().orElse(null), (ValueProviderModel)parameterModel.getValueProviderModel().orElse(null), parameterModel.getAllowedStereotypes(), parameterModel.getModelProperties(), (DeprecationModel)parameterModel.getDeprecationModel().orElse(null));
                parameters.add(typedParameterModel);
            });
            parameterGroups.add((ParameterGroupModel)new ImmutableParameterGroupModel(parameterGroup.getName(), parameterGroup.getDescription(), parameters, parameterGroup.getExclusiveParametersModels(), parameterGroup.isShowInDsl(), (DisplayModel)parameterGroup.getDisplayModel().orElse(null), (LayoutModel)parameterGroup.getLayoutModel().orElse(null), parameterGroup.getModelProperties()));
        });
        return parameterGroups;
    }

    private Optional<SourceCallbackModel> resolveSourceCallbackType(Optional<SourceCallbackModel> sourceCallbackModel, Map<String, ParameterMetadataDescriptor> inputTypeDescriptors) {
        return sourceCallbackModel.map(cb -> new ImmutableSourceCallbackModel(cb.getName(), cb.getDescription(), this.resolveParameterGroupModelType(cb.getParameterGroupModels(), inputTypeDescriptors), (DisplayModel)cb.getDisplayModel().orElse(null), cb.getModelProperties()));
    }

    private OutputModel resolveOutputModelType(OutputModel untypedModel, TypeMetadataDescriptor typeMetadataDescriptor) {
        return new ImmutableOutputModel(untypedModel.getDescription(), typeMetadataDescriptor.getType(), typeMetadataDescriptor.isDynamic(), untypedModel.getModelProperties());
    }
}

