/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.api.metadata;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.Optional;
import java.util.OptionalLong;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.util.LazyLong;
import org.mule.runtime.internal.util.StringByteSizeCalculator;

public final class TypedValue<T>
implements Serializable {
    private static final long serialVersionUID = -3428994331968741687L;
    private final T value;
    private final DataType dataType;
    private transient LazyLong length;

    public static <T> T unwrap(Object value) {
        if (value instanceof TypedValue) {
            return ((TypedValue)value).getValue();
        }
        return (T)value;
    }

    public static <T> TypedValue<T> of(T value) {
        if (value instanceof TypedValue) {
            return (TypedValue)value;
        }
        return new TypedValue<T>(value, value != null ? DataType.fromObject(value) : DataType.OBJECT);
    }

    public TypedValue(T value, DataType dataType) {
        this(value, dataType, OptionalLong.empty());
    }

    @Deprecated
    public TypedValue(T value, DataType dataType, Optional<Long> length) {
        this(value, dataType, length.map(l -> OptionalLong.of(l)).orElse(OptionalLong.empty()));
    }

    public TypedValue(T value, DataType dataType, OptionalLong length) {
        this.value = value;
        this.dataType = dataType == null ? DataType.fromObject(value) : dataType;
        this.length = length.isPresent() ? new LazyLong(length.getAsLong()) : (value instanceof byte[] ? new LazyLong(((byte[])value).length) : (value instanceof String ? new LazyLong(() -> {
            StringByteSizeCalculator stringByteSizeCalculator = new StringByteSizeCalculator();
            Charset charset = this.dataType.getMediaType().getCharset().orElse(Charset.defaultCharset());
            return stringByteSizeCalculator.count((String)value, charset);
        }) : new LazyLong(-1L)));
    }

    public DataType getDataType() {
        return this.dataType;
    }

    public T getValue() {
        return this.value;
    }

    @Deprecated
    public Optional<Long> getLength() {
        long len = this.length.getAsLong();
        return len >= 0L ? Optional.of(len) : Optional.empty();
    }

    public OptionalLong getByteLength() {
        long len = this.length.getAsLong();
        return len >= 0L ? OptionalLong.of(len) : OptionalLong.empty();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TypedValue that = (TypedValue)o;
        if (this.length.getAsLong() != that.length.getAsLong()) {
            return false;
        }
        if (this.value != null ? !this.value.equals(that.value) : that.value != null) {
            return false;
        }
        return this.dataType.equals(that.dataType);
    }

    public int hashCode() {
        int result = this.value != null ? this.value.hashCode() : 0;
        result = 31 * result + this.dataType.hashCode();
        long len = this.length.getAsLong();
        result = 31 * result + (int)(len ^ len >>> 32);
        return result;
    }

    public String toString() {
        return "TypedValue[value: '" + this.value + "', dataType: '" + this.dataType + "']";
    }

    private void readObject(ObjectInputStream in) throws ClassNotFoundException, IOException {
        in.defaultReadObject();
        this.length = new LazyLong(in.readLong());
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeLong(this.length.getAsLong());
    }
}

