/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.scheduler.internal.threads;

import java.security.AccessControlContext;
import java.security.AccessController;
import java.util.Optional;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicLong;
import org.mule.runtime.core.api.util.ClassUtils;

public class SchedulerThreadFactory
implements ThreadFactory {
    private static final AccessControlContext ACCESS_CONTROL_CTX = AccessController.getContext();
    private final ThreadGroup group;
    private final String nameFormat;
    private final AtomicLong counter;
    private final Optional<Integer> priority;

    public SchedulerThreadFactory(ThreadGroup group) {
        this(group, "%s.%02d");
    }

    public SchedulerThreadFactory(ThreadGroup group, String nameFormat) {
        this(group, nameFormat, Optional.empty());
    }

    public SchedulerThreadFactory(ThreadGroup group, String nameFormat, Optional<Integer> priority) {
        this.group = group;
        this.nameFormat = nameFormat;
        this.counter = new AtomicLong(1L);
        this.priority = priority;
    }

    @Override
    public Thread newThread(Runnable runnable) {
        return (Thread)ClassUtils.withContextClassLoader((ClassLoader)this.getClass().getClassLoader(), () -> AccessController.doPrivileged(() -> this.createPrivileged(runnable), ACCESS_CONTROL_CTX));
    }

    private Thread createPrivileged(Runnable runnable) {
        Thread thread = new Thread(this.group, runnable, String.format(this.nameFormat, this.group.getName(), this.counter.getAndIncrement()));
        this.priority.ifPresent(thread::setPriority);
        return thread;
    }

    public ThreadGroup getGroup() {
        return this.group;
    }

    public AtomicLong getCounter() {
        return this.counter;
    }
}

