/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.dsl.api.component;

import org.mule.runtime.dsl.api.component.TypeDefinitionVisitor;

public class TypeDefinition<T> {
    private Class<T> type;
    private String groupName;
    private String attributeName;
    private MapEntryType mapType;
    private Class<?> inforcedClass;

    private TypeDefinition() {
    }

    public static <T> TypeDefinition<T> fromType(Class<T> type) {
        TypeDefinition<T> typeDefinition = new TypeDefinition<T>();
        typeDefinition.type = type;
        return typeDefinition;
    }

    @Deprecated
    public static <T> TypeDefinition<T> fromConfigurationAttribute(String configAttributeName) {
        TypeDefinition<T> typeDefinition = new TypeDefinition<T>();
        typeDefinition.attributeName = configAttributeName;
        return typeDefinition;
    }

    @Deprecated
    public static <T> TypeDefinition<T> fromConfigurationAttribute(String configGroupName, String configAttributeName) {
        TypeDefinition<T> typeDefinition = new TypeDefinition<T>();
        typeDefinition.groupName = configGroupName;
        typeDefinition.attributeName = configAttributeName;
        return typeDefinition;
    }

    public TypeDefinition<T> checkingThatIsClassOrInheritsFrom(Class<?> inforcedClass) {
        this.inforcedClass = inforcedClass;
        return this;
    }

    public void visit(TypeDefinitionVisitor typeDefinitionVisitor) {
        if (this.type != null) {
            typeDefinitionVisitor.onType(this.type);
        } else if (this.mapType != null) {
            typeDefinitionVisitor.onMapType(this.mapType);
        } else if (this.inforcedClass != null) {
            if (this.groupName != null) {
                typeDefinitionVisitor.onConfigurationAttribute(this.groupName, this.attributeName, this.inforcedClass);
            } else {
                typeDefinitionVisitor.onConfigurationAttribute(this.attributeName, this.inforcedClass);
            }
        } else if (this.groupName != null) {
            typeDefinitionVisitor.onConfigurationAttribute(this.groupName, this.attributeName, Object.class);
        } else {
            typeDefinitionVisitor.onConfigurationAttribute(this.attributeName, Object.class);
        }
    }

    public static <T, K, V> TypeDefinition<T> fromMapEntryType(Class<K> keyType, Class<V> valueType) {
        TypeDefinition<T> typeDefinition = new TypeDefinition<T>();
        typeDefinition.mapType = new MapEntryType<K, V>(keyType, valueType);
        return typeDefinition;
    }

    public static class MapEntryType<KeyType, ValueType> {
        private final Class<KeyType> keyType;
        private final Class<ValueType> valueType;

        public MapEntryType(Class<KeyType> keyType, Class<ValueType> valueType) {
            this.keyType = keyType;
            this.valueType = valueType;
        }

        public Class<?> getKeyType() {
            return this.keyType;
        }

        public Class<?> getValueType() {
            return this.valueType;
        }
    }
}

