/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.api.declaration.type;

import java.util.Arrays;
import javax.xml.namespace.QName;
import org.mule.metadata.api.annotation.TypeAnnotation;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.builder.ObjectTypeBuilder;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.runtime.api.util.DataUnit;
import org.mule.runtime.extension.api.ExtensionConstants;
import org.mule.runtime.extension.api.declaration.type.InfrastructureTypeBuilder;
import org.mule.runtime.extension.api.declaration.type.annotation.InfrastructureTypeAnnotation;
import org.mule.runtime.extension.api.declaration.type.annotation.QNameTypeAnnotation;
import org.mule.runtime.extension.internal.dsl.DslConstants;

public final class StreamingStrategyTypeBuilder
extends InfrastructureTypeBuilder {
    private static final String MAX_BUFFER_SIZE = "maxBufferSize";
    private static final String BUFFER_SIZE_INCREMENT = "bufferSizeIncrement";
    private static final String INITIAL_BUFFER_SIZE = "initialBufferSize";
    public static final String REPEATABLE_FILE_STORE_BYTES_STREAM_ALIAS = "repeatable-file-store-stream";
    public static final String REPEATABLE_IN_MEMORY_BYTES_STREAM_ALIAS = "repeatable-in-memory-stream";
    public static final String NON_REPEATABLE_BYTE_STREAM_ALIAS = "non-repeatable-stream";
    public static final String REPEATABLE_IN_MEMORY_OBJECTS_STREAM_ALIAS = "repeatable-in-memory-iterable";
    public static final String REPEATABLE_FILE_STORE_OBJECTS_STREAM_ALIAS = "repeatable-file-store-iterable";
    public static final String NON_REPEATABLE_OBJECTS_STREAM_ALIAS = "non-repeatable-iterable";

    public MetadataType getByteStreamingStrategyType() {
        BaseTypeBuilder typeBuilder = BaseTypeBuilder.create((MetadataFormat)MetadataFormat.JAVA);
        return BaseTypeBuilder.create((MetadataFormat)MetadataFormat.JAVA).unionType().of(this.getInMemoryByteStrategy(typeBuilder)).of(this.getFileStoreByteStrategy(typeBuilder)).of(this.getNoStreamingByteStrategy(typeBuilder)).id("ByteStreamingStrategy").with((TypeAnnotation)new InfrastructureTypeAnnotation()).build();
    }

    public MetadataType getObjectStreamingStrategyType() {
        BaseTypeBuilder typeBuilder = BaseTypeBuilder.create((MetadataFormat)MetadataFormat.JAVA);
        return BaseTypeBuilder.create((MetadataFormat)MetadataFormat.JAVA).unionType().of(this.getInMemoryObjectStrategy(typeBuilder)).of(this.getFileStoreObjectStrategy(typeBuilder)).of(this.getNoStreamingObjectStrategy(typeBuilder)).id("ObjectStreamingStrategy").with((TypeAnnotation)new InfrastructureTypeAnnotation()).build();
    }

    private MetadataType getFileStoreByteStrategy(BaseTypeBuilder typeBuilder) {
        ObjectTypeBuilder streamingType = typeBuilder.objectType().id(REPEATABLE_FILE_STORE_BYTES_STREAM_ALIAS).with((TypeAnnotation)new QNameTypeAnnotation(new QName(DslConstants.EE_NAMESPACE, REPEATABLE_FILE_STORE_BYTES_STREAM_ALIAS, "ee"))).with((TypeAnnotation)new InfrastructureTypeAnnotation());
        this.addIntField(streamingType, typeBuilder, "inMemorySize", "Defines the maximum memory that the stream should use to keep data in memory. If more than that is consumed then it will start to buffer the content on disk.", 512);
        this.addDataUnitField(typeBuilder, streamingType, "The unit in which maxInMemorySize is expressed");
        return streamingType.build();
    }

    private MetadataType getFileStoreObjectStrategy(BaseTypeBuilder typeBuilder) {
        ObjectTypeBuilder streamingType = typeBuilder.objectType().id(REPEATABLE_FILE_STORE_OBJECTS_STREAM_ALIAS).with((TypeAnnotation)new QNameTypeAnnotation(new QName(DslConstants.EE_NAMESPACE, REPEATABLE_FILE_STORE_OBJECTS_STREAM_ALIAS, "ee"))).with((TypeAnnotation)new InfrastructureTypeAnnotation());
        this.addIntField(streamingType, typeBuilder, "inMemoryObjects", "This is the maximum amount of instances that will be kept in memory. If more than that is required, then it will start to buffer the content on disk.", 100);
        this.addDataUnitField(typeBuilder, streamingType, "The unit in which maxInMemorySize is expressed");
        return streamingType.build();
    }

    private MetadataType getInMemoryByteStrategy(BaseTypeBuilder typeBuilder) {
        ObjectTypeBuilder streamingType = typeBuilder.objectType().id(REPEATABLE_IN_MEMORY_BYTES_STREAM_ALIAS).with((TypeAnnotation)new InfrastructureTypeAnnotation());
        this.addIntField(streamingType, typeBuilder, INITIAL_BUFFER_SIZE, "This is the amount of memory that will be allocated in order to consume the stream and provide random access to it. If the stream contains more data than can be fit into this buffer, then it will be expanded by according to the bufferSizeIncrement attribute, with an upper limit of maxInMemorySize.", 512);
        this.addIntField(streamingType, typeBuilder, BUFFER_SIZE_INCREMENT, "This is by how much will be buffer size by expanded if it exceeds its initial size. Setting a value of zero or lower will mean that the buffer should not expand, meaning that a STREAM_MAXIMUM_SIZE_EXCEEDED error will be raised when the buffer gets full.", 512);
        this.addIntField(streamingType, typeBuilder, MAX_BUFFER_SIZE, "This is the maximum amount of memory that will be used. If more than that is used then a STREAM_MAXIMUM_SIZE_EXCEEDED error will be raised. A value lower or equal to zero means no limit.", 1024);
        this.addDataUnitField(typeBuilder, streamingType, "The unit in which all these attributes are expressed");
        return streamingType.build();
    }

    private MetadataType getInMemoryObjectStrategy(BaseTypeBuilder typeBuilder) {
        ObjectTypeBuilder streamingType = typeBuilder.objectType().id(REPEATABLE_IN_MEMORY_OBJECTS_STREAM_ALIAS).with((TypeAnnotation)new InfrastructureTypeAnnotation());
        this.addIntField(streamingType, typeBuilder, INITIAL_BUFFER_SIZE, "This is the amount of instances that will be initially be allowed to be kept in memory in order to consume the stream and provide random access to it. If the stream contains more data than can fit into this buffer, then it will be expanded according to the bufferSizeIncrement attribute, with an upper limit of maxInMemorySize. Default value is 100 instances.", 100);
        this.addIntField(streamingType, typeBuilder, BUFFER_SIZE_INCREMENT, "This is by how much will the buffer size by expanded if it exceeds its initial size. Setting a value of zero or lower will mean that the buffer should not expand, meaning that a STREAM_MAXIMUM_SIZE_EXCEEDED error will be raised when the buffer gets full. Default value is 100 instances.", 100);
        this.addIntField(streamingType, typeBuilder, MAX_BUFFER_SIZE, "This is the maximum amount of memory that will be used. If more than that is used then a STREAM_MAXIMUM_SIZE_EXCEEDED error will be raised. A value lower or equal to zero means no limit.", 500);
        return streamingType.build();
    }

    private void addDataUnitField(BaseTypeBuilder typeBuilder, ObjectTypeBuilder streamingType, String description) {
        this.addEnumField(streamingType, typeBuilder, "bufferUnit", description, ExtensionConstants.DEFAULT_BYTE_STREAMING_BUFFER_DATA_UNIT.name(), (String[])Arrays.stream(DataUnit.values()).map(unit -> unit.name()).toArray(String[]::new));
    }

    private MetadataType getNoStreamingByteStrategy(BaseTypeBuilder typeBuilder) {
        return typeBuilder.objectType().id(NON_REPEATABLE_BYTE_STREAM_ALIAS).with((TypeAnnotation)new InfrastructureTypeAnnotation()).description("This configuration allows the input stream to be read only once. It will not allow to seek randomly which will limit the transformations that DW can perform on this stream. Use this option for use cases which just require moving data around from one system to another to get optimum performance.").build();
    }

    private MetadataType getNoStreamingObjectStrategy(BaseTypeBuilder typeBuilder) {
        return typeBuilder.objectType().id(NON_REPEATABLE_OBJECTS_STREAM_ALIAS).with((TypeAnnotation)new InfrastructureTypeAnnotation()).description("This configuration allows the stream to be read only once. It will not allow to seek randomly which will limit the transformations that DW can perform on this stream. Use this option for use cases which just require moving data around from one system to another to get optimum performance.").build();
    }
}

