/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.netty.impl.message;

import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.HttpVersion;
import java.net.InetSocketAddress;
import java.net.URI;
import java.util.Collection;
import org.mule.runtime.api.util.MultiMap;
import org.mule.runtime.http.api.domain.CaseInsensitiveMultiMap;
import org.mule.runtime.http.api.domain.HttpProtocol;
import org.mule.runtime.http.api.domain.message.BaseHttpMessage;
import org.mule.runtime.http.api.server.HttpServerProperties;
import org.mule.runtime.http.api.utils.HttpEncoderDecoderUtils;
import org.mule.runtime.http.api.utils.UriCache;

public abstract class NettyHttpMessage
extends BaseHttpMessage
implements org.mule.runtime.http.api.domain.message.request.HttpRequest {
    protected final InetSocketAddress localAddress;
    protected final boolean isTransferEncodingChunked;
    protected final long contentLength;
    protected final HttpRequest nettyRequest;
    private String baseUri;
    protected String method;
    protected MultiMap<String, String> queryParams;
    protected HttpProtocol protocol;
    protected URI uri;
    protected String path;

    public NettyHttpMessage(HttpRequest nettyRequest, InetSocketAddress localAddress) {
        super(null);
        this.nettyRequest = nettyRequest;
        this.localAddress = localAddress;
        this.isTransferEncodingChunked = HttpUtil.isTransferEncodingChunked((HttpMessage)this.nettyRequest);
        long contentLengthAsLong = this.isTransferEncodingChunked ? -1L : 0L;
        String contentLengthAsString = this.nettyRequest.headers().getAsString((CharSequence)"Content-Length");
        if (contentLengthAsString != null) {
            contentLengthAsLong = Long.parseLong(contentLengthAsString);
        }
        this.contentLength = contentLengthAsLong;
    }

    public MultiMap<String, String> getQueryParams() {
        if (this.queryParams == null) {
            this.parseUri();
        }
        return this.queryParams;
    }

    public String getPath() {
        if (this.path == null) {
            this.parseUri();
        }
        return this.path;
    }

    public String getMethod() {
        if (this.method == null) {
            this.method = this.nettyRequest.method().name();
        }
        return this.method;
    }

    public HttpProtocol getProtocol() {
        if (this.protocol == null) {
            this.protocol = this.nettyRequest.protocolVersion() == HttpVersion.HTTP_1_0 ? HttpProtocol.HTTP_1_0 : HttpProtocol.HTTP_1_1;
        }
        return this.protocol;
    }

    public Collection<String> getHeaderNames() {
        if (this.headers == null) {
            this.initializeHeaders();
        }
        return this.headers.keySet();
    }

    public String getHeaderValue(String headerName) {
        if (this.headers == null) {
            this.initializeHeaders();
        }
        return (String)this.headers.get((Object)headerName);
    }

    public Collection<String> getHeaderValues(String headerName) {
        if (this.headers == null) {
            this.initializeHeaders();
        }
        return this.headers.getAll((Object)headerName);
    }

    public MultiMap<String, String> getHeaders() {
        if (this.headers == null) {
            this.initializeHeaders();
        }
        return this.headers;
    }

    public boolean containsHeader(String headerName) {
        return this.getHeaders().containsKey((Object)headerName);
    }

    private void initializeHeaders() {
        this.headers = new CaseInsensitiveMultiMap(!HttpServerProperties.PRESERVE_HEADER_CASE);
        this.nettyRequest.headers().forEach(entry -> this.headers.put((Object)((String)entry.getKey()), (Object)((String)entry.getValue())));
        this.headers = this.headers.toImmutableMultiMap();
    }

    public URI getUri() {
        if (this.uri == null) {
            this.parseUri();
        }
        return this.uri;
    }

    private void parseUri() {
        this.baseUri = this.getBaseProtocol() + "://" + this.localAddress.getHostString() + ":" + this.localAddress.getPort();
        String fullUri = this.nettyRequest.uri();
        if (!this.nettyRequest.uri().startsWith("http")) {
            fullUri = this.baseUri + this.nettyRequest.uri();
        }
        this.uri = UriCache.getUriFromString((String)fullUri);
        this.path = this.uri.getRawPath();
        this.queryParams = HttpEncoderDecoderUtils.decodeQueryString((String)this.uri.getRawQuery());
    }

    protected abstract String getBaseProtocol();
}

