/*
 * Decompiled with CFR 0.152.
 */
package jcifs.smb;

import java.io.IOException;
import java.net.MalformedURLException;
import jcifs.CIFSContext;
import jcifs.CIFSException;
import jcifs.SmbRandomAccess;
import jcifs.internal.CommonServerMessageBlockRequest;
import jcifs.internal.fscc.FileEndOfFileInformation;
import jcifs.internal.smb1.com.SmbComWrite;
import jcifs.internal.smb1.com.SmbComWriteAndX;
import jcifs.internal.smb1.com.SmbComWriteAndXResponse;
import jcifs.internal.smb1.com.SmbComWriteResponse;
import jcifs.internal.smb1.trans2.Trans2SetFileInformation;
import jcifs.internal.smb1.trans2.Trans2SetFileInformationResponse;
import jcifs.internal.smb2.info.Smb2SetInfoRequest;
import jcifs.internal.smb2.io.Smb2WriteRequest;
import jcifs.internal.smb2.io.Smb2WriteResponse;
import jcifs.smb.RequestParam;
import jcifs.smb.SmbEndOfFileException;
import jcifs.smb.SmbException;
import jcifs.smb.SmbFile;
import jcifs.smb.SmbFileHandleImpl;
import jcifs.smb.SmbTreeHandleImpl;
import jcifs.util.Encdec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SmbRandomAccessFile
implements SmbRandomAccess {
    private static final Logger log = LoggerFactory.getLogger(SmbRandomAccessFile.class);
    private static final int WRITE_OPTIONS = 2114;
    private SmbFile file;
    private long fp;
    private int openFlags;
    private int access = 0;
    private int readSize;
    private int writeSize;
    private int options = 0;
    private byte[] tmp = new byte[8];
    private SmbComWriteAndXResponse write_andx_resp = null;
    private boolean largeReadX;
    private final boolean unsharedFile;
    private SmbFileHandleImpl handle;
    private int sharing;

    public SmbRandomAccessFile(String url, String mode, int sharing, CIFSContext tc) throws SmbException, MalformedURLException {
        this(new SmbFile(url, tc), mode, sharing, true);
    }

    public SmbRandomAccessFile(SmbFile file, String mode) throws SmbException {
        this(file, mode, 7, false);
    }

    SmbRandomAccessFile(SmbFile file, String mode, int sharing, boolean unsharedFile) throws SmbException {
        this.file = file;
        this.sharing = sharing;
        this.unsharedFile = unsharedFile;
        try (SmbTreeHandleImpl th = this.file.ensureTreeConnected();){
            if (mode.equals("r")) {
                this.openFlags = 17;
                this.access = 1;
            } else if (mode.equals("rw")) {
                this.openFlags = 23;
                this.write_andx_resp = new SmbComWriteAndXResponse(th.getConfig());
                this.options = 2114;
                this.access = 3;
            } else {
                throw new IllegalArgumentException("Invalid mode");
            }
            SmbFileHandleImpl h = this.ensureOpen();
            Throwable throwable = null;
            if (h != null) {
                if (throwable != null) {
                    try {
                        h.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                } else {
                    h.close();
                }
            }
            this.readSize = th.getReceiveBufferSize() - 70;
            this.writeSize = th.getSendBufferSize() - 70;
            if (th.hasCapability(16384)) {
                this.largeReadX = true;
                this.readSize = Math.min(th.getConfig().getReceiveBufferSize() - 70, th.areSignaturesActive() ? 65465 : 0xFFFFB9);
            }
            if (th.hasCapability(32768) && !th.areSignaturesActive()) {
                this.writeSize = Math.min(th.getConfig().getSendBufferSize() - 70, 65465);
            }
            this.fp = 0L;
        }
        catch (CIFSException e) {
            throw SmbException.wrap(e);
        }
    }

    synchronized SmbFileHandleImpl ensureOpen() throws CIFSException {
        if (this.handle == null || !this.handle.isValid()) {
            this.handle = this.file.openUnshared(this.openFlags, this.access, this.sharing, 128, this.options).acquire();
            return this.handle;
        }
        return this.handle.acquire();
    }

    public void open() throws CIFSException {
        SmbFileHandleImpl fh = this.ensureOpen();
        Throwable throwable = null;
        if (fh != null) {
            if (throwable != null) {
                try {
                    fh.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
            } else {
                fh.close();
            }
        }
    }

    @Override
    public synchronized void close() throws SmbException {
        block6: {
            try {
                if (this.handle == null) break block6;
                try {
                    this.handle.close();
                }
                catch (CIFSException e) {
                    throw SmbException.wrap(e);
                }
                this.handle = null;
            }
            finally {
                this.file.clearAttributeCache();
                if (this.unsharedFile) {
                    this.file.close();
                }
            }
        }
    }

    @Override
    public int read() throws SmbException {
        if (this.read(this.tmp, 0, 1) == -1) {
            return -1;
        }
        return this.tmp[0] & 0xFF;
    }

    @Override
    public int read(byte[] b) throws SmbException {
        return this.read(b, 0, b.length);
    }

    /*
     * Exception decompiling
     */
    @Override
    public int read(byte[] b, int off, int len) throws SmbException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 31[DOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public final void readFully(byte[] b) throws SmbException {
        this.readFully(b, 0, b.length);
    }

    @Override
    public final void readFully(byte[] b, int off, int len) throws SmbException {
        int count;
        int n = 0;
        do {
            if ((count = this.read(b, off + n, len - n)) >= 0) continue;
            throw new SmbEndOfFileException();
        } while ((n += count) < len);
    }

    @Override
    public int skipBytes(int n) throws SmbException {
        if (n > 0) {
            this.fp += (long)n;
            return n;
        }
        return 0;
    }

    @Override
    public void write(int b) throws SmbException {
        this.tmp[0] = (byte)b;
        this.write(this.tmp, 0, 1);
    }

    @Override
    public void write(byte[] b) throws SmbException {
        this.write(b, 0, b.length);
    }

    @Override
    public void write(byte[] b, int off, int len) throws SmbException {
        if (len <= 0) {
            return;
        }
        try (SmbFileHandleImpl fh = this.ensureOpen();
             SmbTreeHandleImpl th = fh.getTree();){
            do {
                long cnt;
                CommonServerMessageBlockRequest request;
                int w;
                int n = w = len > this.writeSize ? this.writeSize : len;
                if (th.isSMB2()) {
                    request = new Smb2WriteRequest(th.getConfig(), fh.getFileId());
                    ((Smb2WriteRequest)request).setOffset(this.fp);
                    ((Smb2WriteRequest)request).setRemainingBytes(len - w - off);
                    ((Smb2WriteRequest)request).setData(b, off, w);
                    Smb2WriteResponse resp = (Smb2WriteResponse)th.send(request, new RequestParam[]{RequestParam.NO_RETRY});
                    cnt = resp.getCount();
                } else {
                    request = new SmbComWriteAndX(th.getConfig(), fh.getFid(), this.fp, len - w - off, b, off, w, null);
                    th.send(request, this.write_andx_resp, RequestParam.NO_RETRY);
                    cnt = this.write_andx_resp.getCount();
                }
                this.fp += cnt;
                len = (int)((long)len - cnt);
                off = (int)((long)off + cnt);
            } while (len > 0);
        }
        catch (CIFSException e) {
            throw SmbException.wrap(e);
        }
    }

    @Override
    public long getFilePointer() {
        return this.fp;
    }

    @Override
    public void seek(long pos) {
        this.fp = pos;
    }

    @Override
    public long length() throws SmbException {
        return this.file.length();
    }

    @Override
    public void setLength(long newLength) throws SmbException {
        try (SmbFileHandleImpl fh = this.ensureOpen();
             SmbTreeHandleImpl th = fh.getTree();){
            if (th.isSMB2()) {
                Smb2SetInfoRequest req = new Smb2SetInfoRequest(th.getConfig(), fh.getFileId());
                req.setFileInformation(new FileEndOfFileInformation(newLength));
                th.send(req, RequestParam.NO_RETRY);
            } else if (th.hasCapability(16)) {
                th.send((CommonServerMessageBlockRequest)new Trans2SetFileInformation(th.getConfig(), fh.getFid(), new FileEndOfFileInformation(newLength)), new Trans2SetFileInformationResponse(th.getConfig()), RequestParam.NO_RETRY);
            } else {
                SmbComWriteResponse rsp = new SmbComWriteResponse(th.getConfig());
                th.send((CommonServerMessageBlockRequest)new SmbComWrite(th.getConfig(), fh.getFid(), (int)(newLength & 0xFFFFFFFFL), 0, this.tmp, 0, 0), rsp, RequestParam.NO_RETRY);
            }
        }
        catch (CIFSException e) {
            throw SmbException.wrap(e);
        }
    }

    @Override
    public final boolean readBoolean() throws SmbException {
        if (this.read(this.tmp, 0, 1) < 0) {
            throw new SmbEndOfFileException();
        }
        return this.tmp[0] != 0;
    }

    @Override
    public final byte readByte() throws SmbException {
        if (this.read(this.tmp, 0, 1) < 0) {
            throw new SmbEndOfFileException();
        }
        return this.tmp[0];
    }

    @Override
    public final int readUnsignedByte() throws SmbException {
        if (this.read(this.tmp, 0, 1) < 0) {
            throw new SmbEndOfFileException();
        }
        return this.tmp[0] & 0xFF;
    }

    @Override
    public final short readShort() throws SmbException {
        if (this.read(this.tmp, 0, 2) < 0) {
            throw new SmbEndOfFileException();
        }
        return Encdec.dec_uint16be(this.tmp, 0);
    }

    @Override
    public final int readUnsignedShort() throws SmbException {
        if (this.read(this.tmp, 0, 2) < 0) {
            throw new SmbEndOfFileException();
        }
        return Encdec.dec_uint16be(this.tmp, 0) & 0xFFFF;
    }

    @Override
    public final char readChar() throws SmbException {
        if (this.read(this.tmp, 0, 2) < 0) {
            throw new SmbEndOfFileException();
        }
        return (char)Encdec.dec_uint16be(this.tmp, 0);
    }

    @Override
    public final int readInt() throws SmbException {
        if (this.read(this.tmp, 0, 4) < 0) {
            throw new SmbEndOfFileException();
        }
        return Encdec.dec_uint32be(this.tmp, 0);
    }

    @Override
    public final long readLong() throws SmbException {
        if (this.read(this.tmp, 0, 8) < 0) {
            throw new SmbEndOfFileException();
        }
        return Encdec.dec_uint64be(this.tmp, 0);
    }

    @Override
    public final float readFloat() throws SmbException {
        if (this.read(this.tmp, 0, 4) < 0) {
            throw new SmbEndOfFileException();
        }
        return Encdec.dec_floatbe(this.tmp, 0);
    }

    @Override
    public final double readDouble() throws SmbException {
        if (this.read(this.tmp, 0, 8) < 0) {
            throw new SmbEndOfFileException();
        }
        return Encdec.dec_doublebe(this.tmp, 0);
    }

    @Override
    public final String readLine() throws SmbException {
        StringBuffer input = new StringBuffer();
        int c = -1;
        boolean eol = false;
        block4: while (!eol) {
            c = this.read();
            switch (c) {
                case -1: 
                case 10: {
                    eol = true;
                    continue block4;
                }
                case 13: {
                    eol = true;
                    long cur = this.fp;
                    if (this.read() == 10) continue block4;
                    this.fp = cur;
                    continue block4;
                }
            }
            input.append((char)c);
        }
        if (c == -1 && input.length() == 0) {
            return null;
        }
        return input.toString();
    }

    @Override
    public final String readUTF() throws SmbException {
        int size = this.readUnsignedShort();
        byte[] b = new byte[size];
        this.read(b, 0, size);
        try {
            return Encdec.dec_utf8(b, 0, size);
        }
        catch (IOException ioe) {
            throw new SmbException("", (Throwable)ioe);
        }
    }

    @Override
    public final void writeBoolean(boolean v) throws SmbException {
        this.tmp[0] = (byte)(v ? 1 : 0);
        this.write(this.tmp, 0, 1);
    }

    @Override
    public final void writeByte(int v) throws SmbException {
        this.tmp[0] = (byte)v;
        this.write(this.tmp, 0, 1);
    }

    @Override
    public final void writeShort(int v) throws SmbException {
        Encdec.enc_uint16be((short)v, this.tmp, 0);
        this.write(this.tmp, 0, 2);
    }

    @Override
    public final void writeChar(int v) throws SmbException {
        Encdec.enc_uint16be((short)v, this.tmp, 0);
        this.write(this.tmp, 0, 2);
    }

    @Override
    public final void writeInt(int v) throws SmbException {
        Encdec.enc_uint32be(v, this.tmp, 0);
        this.write(this.tmp, 0, 4);
    }

    @Override
    public final void writeLong(long v) throws SmbException {
        Encdec.enc_uint64be(v, this.tmp, 0);
        this.write(this.tmp, 0, 8);
    }

    @Override
    public final void writeFloat(float v) throws SmbException {
        Encdec.enc_floatbe(v, this.tmp, 0);
        this.write(this.tmp, 0, 4);
    }

    @Override
    public final void writeDouble(double v) throws SmbException {
        Encdec.enc_doublebe(v, this.tmp, 0);
        this.write(this.tmp, 0, 8);
    }

    @Override
    public final void writeBytes(String s) throws SmbException {
        byte[] b = s.getBytes();
        this.write(b, 0, b.length);
    }

    @Override
    public final void writeChars(String s) throws SmbException {
        int clen = s.length();
        int blen = 2 * clen;
        byte[] b = new byte[blen];
        char[] c = new char[clen];
        s.getChars(0, clen, c, 0);
        int j = 0;
        for (int i = 0; i < clen; ++i) {
            b[j++] = (byte)(c[i] >>> 8);
            b[j++] = (byte)(c[i] >>> 0);
        }
        this.write(b, 0, blen);
    }

    @Override
    public final void writeUTF(String str) throws SmbException {
        int len = str.length();
        int size = 0;
        for (int i = 0; i < len; ++i) {
            char ch = str.charAt(i);
            size += ch > '\u007f' ? (ch > '\u07ff' ? 3 : 2) : 1;
        }
        byte[] dst = new byte[size];
        this.writeShort(size);
        Encdec.enc_utf8(str, dst, 0, size);
        this.write(dst, 0, size);
    }
}

