/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.lib;

import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import net.sf.saxon.trans.UncheckedXPathException;

public class DigestMaker {
    private String hexDigest = null;
    private final MessageDigest digest;

    public DigestMaker() {
        try {
            this.digest = MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException ex) {
            throw new UncheckedXPathException(ex);
        }
    }

    public void update(int value) {
        this.digest.update(String.valueOf(value).getBytes(StandardCharsets.UTF_8));
    }

    public void update(String value) {
        this.digest.update(value.getBytes(StandardCharsets.UTF_8));
    }

    public String getDigest() {
        if (this.hexDigest == null) {
            this.hexDigest = String.format("%064x", new BigInteger(1, this.digest.digest()));
        }
        return this.hexDigest;
    }
}

