/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.util.rx;

import java.util.Collection;
import java.util.List;
import java.util.TimeZone;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Supplier;
import org.mule.runtime.api.scheduler.Scheduler;

public class RetrySchedulerWrapper
implements Scheduler {
    private final Scheduler delegate;
    private final long retryTime;
    private final Runnable onRetry;

    public RetrySchedulerWrapper(Scheduler delegate, long retryTime) {
        this(delegate, retryTime, () -> {});
    }

    public RetrySchedulerWrapper(Scheduler delegate, long retryTime, Runnable onRetry) {
        this.delegate = delegate;
        this.retryTime = retryTime;
        this.onRetry = onRetry;
    }

    public ScheduledFuture<?> scheduleWithCronExpression(Runnable command, String cronExpression) {
        return this.delegate.scheduleWithCronExpression(command, cronExpression);
    }

    public ScheduledFuture<?> scheduleWithCronExpression(Runnable command, String cronExpression, TimeZone timeZone) {
        return this.delegate.scheduleWithCronExpression(command, cronExpression, timeZone);
    }

    public void stop() {
        this.delegate.stop();
    }

    public String getName() {
        return this.delegate.getName();
    }

    public ScheduledFuture<?> schedule(Runnable command, long delay, TimeUnit unit) {
        return this.delegate.schedule(command, delay, unit);
    }

    public <V> ScheduledFuture<V> schedule(Callable<V> callable, long delay, TimeUnit unit) {
        return this.delegate.schedule(callable, delay, unit);
    }

    public ScheduledFuture<?> scheduleAtFixedRate(Runnable command, long initialDelay, long period, TimeUnit unit) {
        return this.delegate.scheduleAtFixedRate(command, initialDelay, period, unit);
    }

    public ScheduledFuture<?> scheduleWithFixedDelay(Runnable command, long initialDelay, long delay, TimeUnit unit) {
        return this.delegate.scheduleWithFixedDelay(command, initialDelay, delay, unit);
    }

    public void shutdown() {
        this.delegate.shutdown();
    }

    public List<Runnable> shutdownNow() {
        return this.delegate.shutdownNow();
    }

    public boolean isShutdown() {
        return this.delegate.isShutdown();
    }

    public boolean isTerminated() {
        return this.delegate.isTerminated();
    }

    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        return this.delegate.awaitTermination(timeout, unit);
    }

    private <T> Future<T> runWithRetry(Supplier<Future<T>> operation) {
        while (!this.isShutdown() && !this.isTerminated()) {
            try {
                return operation.get();
            }
            catch (RejectedExecutionException ree) {
                this.onRetry.run();
                try {
                    Thread.sleep(this.retryTime);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new RejectedExecutionException();
                }
            }
        }
        throw new RejectedExecutionException(this.toString());
    }

    public <T> Future<T> submit(Callable<T> task) {
        return this.runWithRetry(() -> this.delegate.submit(task));
    }

    public <T> Future<T> submit(Runnable task, T result) {
        return this.runWithRetry(() -> this.delegate.submit(task, result));
    }

    public Future<?> submit(Runnable task) {
        return this.runWithRetry(() -> this.delegate.submit(task));
    }

    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
        return this.delegate.invokeAll(tasks);
    }

    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
        return this.delegate.invokeAll(tasks, timeout, unit);
    }

    public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
        return (T)this.delegate.invokeAny(tasks);
    }

    public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return (T)this.delegate.invokeAny(tasks, timeout, unit);
    }

    public void execute(Runnable command) {
        this.runWithRetry(() -> {
            this.delegate.execute(command);
            return null;
        });
    }

    public String toString() {
        return "RetrySchedulerWrapper{" + this.delegate.toString() + "}";
    }
}

