/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal.dsl.spring;

import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import javax.xml.namespace.QName;
import org.mule.runtime.api.component.Component;
import org.mule.runtime.api.util.LazyValue;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.config.internal.dsl.model.SpringComponentModel;
import org.mule.runtime.config.internal.dsl.spring.BeanDefinitionBuilderHelper;
import org.mule.runtime.config.internal.dsl.spring.BeanDefinitionCreator;
import org.mule.runtime.config.internal.dsl.spring.ComponentConfigurationBuilder;
import org.mule.runtime.config.internal.dsl.spring.CreateBeanDefinitionRequest;
import org.mule.runtime.config.internal.dsl.spring.ObjectFactoryClassRepository;
import org.mule.runtime.core.internal.execution.LocationExecutionContextProvider;
import org.mule.runtime.dsl.api.component.ComponentBuildingDefinition;
import org.mule.runtime.module.extension.internal.runtime.resolver.ValueResolver;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;

abstract class CommonBeanBaseDefinitionCreator<R extends CreateBeanDefinitionRequest>
extends BeanDefinitionCreator<R> {
    private final ObjectFactoryClassRepository objectFactoryClassRepository;
    private final boolean disableTrimWhitespaces;

    public CommonBeanBaseDefinitionCreator(ObjectFactoryClassRepository objectFactoryClassRepository, boolean disableTrimWhitespaces) {
        this.objectFactoryClassRepository = objectFactoryClassRepository;
        this.disableTrimWhitespaces = disableTrimWhitespaces;
    }

    @Override
    public boolean handleRequest(Map<ComponentAst, SpringComponentModel> springComponentModels, R request) {
        ComponentBuildingDefinition buildingDefinition = ((CreateBeanDefinitionRequest)request).getComponentBuildingDefinition();
        if (buildingDefinition == null) {
            return false;
        }
        BeanDefinitionBuilder beanDefinitionBuilder = this.createBeanDefinitionBuilder(((CreateBeanDefinitionRequest)request).getSpringComponentModel(), buildingDefinition);
        this.processAnnotations(((CreateBeanDefinitionRequest)request).getSpringComponentModel(), beanDefinitionBuilder);
        this.processComponentDefinitionModel(springComponentModels, request, buildingDefinition, beanDefinitionBuilder);
        return true;
    }

    private BeanDefinitionBuilder createBeanDefinitionBuilder(SpringComponentModel componentModel, ComponentBuildingDefinition buildingDefinition) {
        if (buildingDefinition.getObjectFactoryType() != null) {
            return this.createBeanDefinitionBuilderFromObjectFactory(componentModel, buildingDefinition);
        }
        return BeanDefinitionBuilder.genericBeanDefinition(componentModel.getType());
    }

    protected final void processAnnotations(SpringComponentModel componentModel, BeanDefinitionBuilder beanDefinitionBuilder) {
        Map<QName, Object> annotations;
        if ((Component.class.isAssignableFrom(componentModel.getType()) || ValueResolver.class.isAssignableFrom(componentModel.getType())) && !(annotations = this.processMetadataAnnotationsHelper(beanDefinitionBuilder, componentModel.getComponent())).isEmpty()) {
            beanDefinitionBuilder.addPropertyValue("annotations", annotations);
        }
    }

    private Map<QName, Object> processMetadataAnnotationsHelper(BeanDefinitionBuilder builder, ComponentAst componentModel) {
        HashMap<QName, Object> annotations = new HashMap<QName, Object>();
        if (componentModel != null && Component.class.isAssignableFrom(builder.getBeanDefinition().getBeanClass())) {
            this.addMetadataAnnotationsFromDocAttributes(annotations, componentModel);
            builder.getBeanDefinition().getPropertyValues().addPropertyValue("annotations", annotations);
        }
        return annotations;
    }

    protected void addMetadataAnnotationsFromDocAttributes(Map<QName, Object> beanAnnotations, ComponentAst component) {
        String sourceCode = component.getMetadata().getSourceCode().orElse(null);
        if (sourceCode != null) {
            beanAnnotations.put(Component.Annotations.SOURCE_ELEMENT_ANNOTATION_KEY, LocationExecutionContextProvider.maskPasswords((String)sourceCode));
        }
        beanAnnotations.putAll(component.getAnnotations().entrySet().stream().collect(Collectors.toMap(e -> QName.valueOf((String)e.getKey()), Map.Entry::getValue)));
        beanAnnotations.putAll(component.getMetadata().getDocAttributes().entrySet().stream().collect(Collectors.toMap(e -> new QName("http://www.mulesoft.org/schema/mule/documentation", (String)e.getKey()), Map.Entry::getValue)));
    }

    private BeanDefinitionBuilder createBeanDefinitionBuilderFromObjectFactory(SpringComponentModel componentModel, ComponentBuildingDefinition componentBuildingDefinition) {
        Class objectFactoryType = componentBuildingDefinition.getObjectFactoryType();
        return BeanDefinitionBuilder.rootBeanDefinition(this.objectFactoryClassRepository.getObjectFactoryClass(objectFactoryType, componentModel.getType())).addPropertyValue("isSingleton", (Object)(!componentBuildingDefinition.isPrototype() ? 1 : 0)).addPropertyValue("isPrototype", (Object)componentBuildingDefinition.isPrototype()).addPropertyValue("isEagerInit", (Object)new LazyValue(() -> !componentModel.getBeanDefinition().isLazyInit()));
    }

    protected abstract void processComponentDefinitionModel(Map<ComponentAst, SpringComponentModel> var1, R var2, ComponentBuildingDefinition var3, BeanDefinitionBuilder var4);

    protected final void processObjectConstructionParameters(Map<ComponentAst, SpringComponentModel> springComponentModels, ComponentAst ownerComponent, ComponentAst componentModel, CreateBeanDefinitionRequest createBeanDefinitionRequest, BeanDefinitionBuilderHelper beanDefinitionBuilderHelper) {
        new ComponentConfigurationBuilder(springComponentModels, ownerComponent, componentModel, createBeanDefinitionRequest, beanDefinitionBuilderHelper, this.disableTrimWhitespaces).processConfiguration();
    }
}

