/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.soap.security;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import org.mule.runtime.extension.api.soap.security.config.WssKeyStoreConfiguration;
import org.mule.service.soap.security.SecurityStrategyCxfAdapter;
import org.mule.service.soap.security.SecurityStrategyType;
import org.mule.service.soap.security.callback.WSPasswordCallbackHandler;
import org.mule.service.soap.security.config.WssKeyStoreConfigurationPropertiesBuilder;

public class WssDecryptSecurityStrategyCxfAdapter
implements SecurityStrategyCxfAdapter {
    private static final String WS_DECRYPT_PROPERTIES_KEY = "decryptProperties";
    private WssKeyStoreConfigurationPropertiesBuilder keyStoreConfiguration;

    public WssDecryptSecurityStrategyCxfAdapter(WssKeyStoreConfiguration keyStoreConfiguration) {
        this.keyStoreConfiguration = new WssKeyStoreConfigurationPropertiesBuilder(keyStoreConfiguration);
    }

    @Override
    public SecurityStrategyType securityType() {
        return SecurityStrategyType.INCOMING;
    }

    @Override
    public String securityAction() {
        return "Encrypt";
    }

    @Override
    public Optional<WSPasswordCallbackHandler> buildPasswordCallbackHandler() {
        return Optional.of(new WSPasswordCallbackHandler(1, cb -> cb.setPassword(this.keyStoreConfiguration.getKeyPassword())));
    }

    @Override
    public Map<String, Object> buildSecurityProperties() {
        return ImmutableMap.builder().put((Object)"decryptionPropRefId", (Object)WS_DECRYPT_PROPERTIES_KEY).put((Object)WS_DECRYPT_PROPERTIES_KEY, (Object)this.keyStoreConfiguration.getConfigurationProperties()).build();
    }
}

