/*
 * Decompiled with CFR 0.152.
 */
package com.ning.http.client.generators;

import com.ning.http.client.BodyGenerator;
import com.ning.http.client.RandomAccessBody;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;

public class FileBodyGenerator
implements BodyGenerator {
    private final File file;
    private final long regionSeek;
    private final long regionLength;

    public FileBodyGenerator(File file) {
        if (file == null) {
            throw new NullPointerException("file");
        }
        this.file = file;
        this.regionLength = file.length();
        this.regionSeek = 0L;
    }

    public FileBodyGenerator(File file, long regionSeek, long regionLength) {
        if (file == null) {
            throw new NullPointerException("file");
        }
        this.file = file;
        this.regionLength = regionLength;
        this.regionSeek = regionSeek;
    }

    @Override
    public RandomAccessBody createBody() throws IOException {
        return new FileBody(this.file, this.regionSeek, this.regionLength);
    }

    public File getFile() {
        return this.file;
    }

    public long getRegionSeek() {
        return this.regionSeek;
    }

    public long getRegionLength() {
        return this.regionLength;
    }

    protected static class FileBody
    implements RandomAccessBody {
        private final RandomAccessFile file;
        private final FileChannel channel;
        private final long length;

        public FileBody(File file) throws IOException {
            this.file = new RandomAccessFile(file, "r");
            this.channel = this.file.getChannel();
            this.length = file.length();
        }

        public FileBody(File file, long regionSeek, long regionLength) throws IOException {
            this.file = new RandomAccessFile(file, "r");
            this.channel = this.file.getChannel();
            this.length = regionLength;
            if (regionSeek > 0L) {
                this.file.seek(regionSeek);
            }
        }

        @Override
        public long getContentLength() {
            return this.length;
        }

        @Override
        public long read(ByteBuffer buffer) throws IOException {
            return this.channel.read(buffer);
        }

        @Override
        public long transferTo(long position, WritableByteChannel target) throws IOException {
            return this.channel.transferTo(position, this.length, target);
        }

        @Override
        public void close() throws IOException {
            this.file.close();
        }
    }
}

