/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.container.api;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.core.api.util.StringUtils;
import org.mule.runtime.jpms.api.MuleContainerModule;
import org.mule.runtime.module.artifact.api.classloader.ExportedService;

public class MuleModule
implements MuleContainerModule {
    private final String name;
    private final Set<String> exportedPackages;
    private final Set<String> exportedPaths;
    private final Set<String> privilegedExportedPackages;
    private final Set<String> privilegedArtifacts;
    private final List<ExportedService> exportedServices;

    public MuleModule(String name, Set<String> exportedPackages, Set<String> exportedPaths, Set<String> privilegedExportedPackages, Set<String> privilegedArtifacts, List<ExportedService> exportedServices) {
        Preconditions.checkArgument((!StringUtils.isEmpty((String)name) ? 1 : 0) != 0, (String)"name cannot be empty");
        Preconditions.checkArgument((exportedPackages != null ? 1 : 0) != 0, (String)"exportedPackages cannot be null");
        Preconditions.checkArgument((exportedPaths != null ? 1 : 0) != 0, (String)"exportedPaths cannot be null");
        Preconditions.checkArgument((!this.containsMetaInfServicesResource(exportedPaths) ? 1 : 0) != 0, (String)"exportedPaths cannot contain paths on META-INF/services");
        Preconditions.checkArgument((privilegedExportedPackages != null ? 1 : 0) != 0, (String)"privilegedExportedPackages cannot be null");
        Preconditions.checkArgument((privilegedArtifacts != null ? 1 : 0) != 0, (String)"privilegedArtifacts cannot be null");
        Preconditions.checkArgument((exportedServices != null ? 1 : 0) != 0, (String)"exportedServices cannot be null");
        this.name = name;
        this.exportedPackages = Collections.unmodifiableSet(exportedPackages);
        this.exportedPaths = Collections.unmodifiableSet(exportedPaths);
        this.privilegedExportedPackages = privilegedExportedPackages;
        this.privilegedArtifacts = privilegedArtifacts;
        this.exportedServices = exportedServices;
    }

    private boolean containsMetaInfServicesResource(Set<String> exportedPaths) {
        return exportedPaths.stream().filter(s -> s.startsWith("META-INF/services")).findAny().isPresent();
    }

    public String getName() {
        return this.name;
    }

    public Set<String> getExportedPackages() {
        return this.exportedPackages;
    }

    public Set<String> getExportedPaths() {
        return this.exportedPaths;
    }

    public Set<String> getPrivilegedExportedPackages() {
        return this.privilegedExportedPackages;
    }

    public Set<String> getPrivilegedArtifacts() {
        return this.privilegedArtifacts;
    }

    public List<ExportedService> getExportedServices() {
        return this.exportedServices != null ? this.exportedServices : Collections.emptyList();
    }

    public String toString() {
        return this.getClass().getName() + "[" + this.name + "]";
    }
}

