/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.message;

import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.mule.runtime.core.api.event.CoreEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ExceptionMessage
implements Serializable {
    private static final long serialVersionUID = -538516243574950621L;
    private static final Logger logger = LoggerFactory.getLogger(ExceptionMessage.class);
    private transient Object payload;
    private transient Throwable exception;
    protected Map<String, Object> properties;
    private final String componentName;
    private String connectorName;
    private final Date timeStamp;

    public ExceptionMessage(CoreEvent event, Throwable exception, String componentName, String connectorName) {
        this.payload = event.getMessage().getPayload().getValue();
        this.properties = new HashMap<String, Object>();
        this.exception = exception;
        this.timeStamp = new Date();
        this.componentName = componentName;
        if (connectorName != null) {
            this.connectorName = connectorName.toString();
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        try {
            out.writeObject(this.exception);
        }
        catch (NotSerializableException e) {
            logger.warn("Exception " + this.exception.getClass().getName() + " is not serializable and will be lost when sending ExceptionMessage over the wire: " + e.getMessage());
        }
        try {
            out.writeObject(this.payload);
        }
        catch (NotSerializableException e) {
            logger.warn("Payload " + this.payload.getClass().getName() + " is not serializable and will be lost when sending ExceptionMessage over the wire: " + e.getMessage());
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        try {
            this.exception = (Throwable)in.readObject();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.payload = in.readObject();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setPayload(Object payload) {
        this.payload = payload;
    }

    public Object getPayload() {
        return this.payload;
    }

    public void addProperties(Map<String, Object> properties) {
        this.properties.putAll(properties);
    }

    public void clearProperties() {
        this.properties.clear();
    }

    public String getComponentName() {
        return this.componentName;
    }

    public String getConnectorName() {
        return this.connectorName;
    }

    public Date getTimeStamp() {
        return this.timeStamp;
    }

    public Throwable getException() {
        return this.exception;
    }

    public String toString() {
        return "ExceptionMessage{payload=" + this.getPayload() + ", context=" + this.properties + "exception=" + this.exception + ", componentName='" + this.componentName + "', connectorName=" + this.connectorName + ", timeStamp=" + this.timeStamp + "}";
    }
}

