/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.api.management.stats;

import java.io.Serializable;
import java.util.concurrent.atomic.AtomicLong;
import org.mule.api.annotation.NoExtend;
import org.mule.runtime.core.api.construct.FlowConstruct;
import org.mule.runtime.core.api.management.stats.FlowConstructStatistics;
import org.mule.runtime.core.api.management.stats.ProcessingTimeWatcher;

@NoExtend
public class ProcessingTime
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final AtomicLong accumulator = new AtomicLong();
    private final FlowConstructStatistics statistics;

    public static ProcessingTime newInstance(FlowConstruct flow) {
        FlowConstructStatistics stats = flow.getStatistics();
        if (stats != null && flow.getStatistics().isEnabled()) {
            return new ProcessingTime(stats, flow.getMuleContext().getProcessorTimeWatcher());
        }
        return null;
    }

    private ProcessingTime(FlowConstructStatistics stats, ProcessingTimeWatcher processorTimeWatcher) {
        this.statistics = stats;
        processorTimeWatcher.addProcessingTime(this);
    }

    public void addFlowExecutionBranchTime(long startTime) {
        if (this.statistics.isEnabled()) {
            long elapsedTime = ProcessingTime.getEffectiveTime(System.currentTimeMillis() - startTime);
            this.statistics.addFlowExecutionBranchTime(elapsedTime, this.accumulator.addAndGet(elapsedTime));
        }
    }

    public static long getEffectiveTime(long time) {
        return time <= 0L ? 1L : time;
    }

    public FlowConstructStatistics getStatistics() {
        return this.statistics;
    }

    public AtomicLong getAccumulator() {
        return this.accumulator;
    }
}

