/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.pattern;

import net.sf.saxon.Configuration;
import net.sf.saxon.expr.AxisExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.FilterExpression;
import net.sf.saxon.expr.FirstItemExpression;
import net.sf.saxon.expr.LastItemExpression;
import net.sf.saxon.expr.LocalBinding;
import net.sf.saxon.expr.LocalVariableReference;
import net.sf.saxon.expr.Operand;
import net.sf.saxon.expr.OperandRole;
import net.sf.saxon.expr.SingleItemFilter;
import net.sf.saxon.expr.SlashExpression;
import net.sf.saxon.expr.UnaryExpression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMinor;
import net.sf.saxon.expr.elab.PullEvaluator;
import net.sf.saxon.expr.instruct.SlotManager;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.RebindingMap;
import net.sf.saxon.functions.Current;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.pattern.AnyNodeTest;
import net.sf.saxon.pattern.BasePatternWithPredicate;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.pattern.Pattern;
import net.sf.saxon.pattern.PatternMaker;
import net.sf.saxon.pattern.UniversalPattern;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.AxisIterator;
import net.sf.saxon.tree.iter.ManualIterator;
import net.sf.saxon.type.AlphaCode;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.type.UType;

public final class GeneralNodePattern
extends Pattern {
    private Expression equivalentExpr;
    private final NodeTest itemType;
    private Expression topNodeEquivalent = null;
    private PullEvaluator equivalentExprEvaluator;
    private PullEvaluator equivalentTopNodeEvaluator;
    private Pattern precondition = null;

    public GeneralNodePattern(Expression expr, NodeTest itemType) {
        this.equivalentExpr = expr;
        this.itemType = itemType;
    }

    public void makeTopNodeEquivalent() {
        Expression head;
        if (this.equivalentExpr instanceof SlashExpression && ExpressionTool.getAxisNavigation(head = ((SlashExpression)this.equivalentExpr).getFirstStep()) == 3) {
            SlashExpression copy = (SlashExpression)this.equivalentExpr.copy(new RebindingMap());
            Expression copyHead = copy.getFirstStep();
            while (true) {
                if (copyHead instanceof FilterExpression) {
                    copyHead = ((FilterExpression)copyHead).getBase();
                    continue;
                }
                if (!(copyHead instanceof SingleItemFilter)) break;
                copyHead = ((SingleItemFilter)copyHead).getBaseExpression();
            }
            if (copyHead instanceof AxisExpression) {
                ((AxisExpression)copyHead).setAxis(12);
                this.topNodeEquivalent = copy;
            }
        }
    }

    @Override
    public Iterable<Operand> operands() {
        return new Operand(this, this.equivalentExpr, OperandRole.SAME_FOCUS_ACTION);
    }

    @Override
    public boolean isMotionless() {
        return false;
    }

    @Override
    public Pattern typeCheck(ExpressionVisitor visitor, ContextItemStaticInfo contextItemType) throws XPathException {
        ContextItemStaticInfo cit = new ContextItemStaticInfo(AnyNodeTest.getInstance(), false);
        this.equivalentExpr = this.equivalentExpr.typeCheck(visitor, cit);
        this.makeTopNodeEquivalent();
        return this;
    }

    @Override
    public Pattern optimize(ExpressionVisitor visitor, ContextItemStaticInfo contextInfo) throws XPathException {
        UnaryExpression unaryExpr;
        Expression baseExpr;
        Configuration config = visitor.getConfiguration();
        ContextItemStaticInfo defaultInfo = config.getDefaultContextItemStaticInfo();
        this.equivalentExpr = this.equivalentExpr.optimize(visitor, defaultInfo);
        if (this.equivalentExpr instanceof FilterExpression && !((FilterExpression)this.equivalentExpr).isFilterIsPositional()) {
            try {
                return PatternMaker.fromExpression(this.equivalentExpr, config, true).typeCheck(visitor, defaultInfo);
            }
            catch (XPathException xPathException) {
                // empty catch block
            }
        }
        if ((this.equivalentExpr instanceof FirstItemExpression || this.equivalentExpr instanceof LastItemExpression) && (baseExpr = (unaryExpr = (UnaryExpression)this.equivalentExpr).getBaseExpression()) instanceof FilterExpression && !((FilterExpression)baseExpr).isFilterIsPositional()) {
            this.precondition = new BasePatternWithPredicate(new UniversalPattern(), ((FilterExpression)baseExpr).getFilter().copy(new RebindingMap()));
            this.precondition = this.precondition.typeCheck(visitor, contextInfo).optimize(visitor, contextInfo);
        }
        return this;
    }

    @Override
    public int getDependencies() {
        return this.equivalentExpr.getDependencies() & 0x180;
    }

    @Override
    public void bindCurrent(LocalBinding binding) {
        if (ExpressionTool.callsFunction(this.equivalentExpr, Current.FN_CURRENT, false)) {
            if (this.equivalentExpr.isCallOn(Current.class)) {
                this.equivalentExpr = new LocalVariableReference(binding);
            } else {
                GeneralNodePattern.replaceCurrent(this.equivalentExpr, binding);
            }
        }
    }

    @Override
    public int allocateSlots(SlotManager slotManager, int nextFree) {
        return ExpressionTool.allocateSlots(this.equivalentExpr, nextFree, slotManager);
    }

    @Override
    public boolean matches(Item item, XPathContext context) throws XPathException {
        TypeHierarchy th = context.getConfiguration().getTypeHierarchy();
        if (!this.itemType.matches(item, th)) {
            return false;
        }
        if (this.precondition != null && !this.precondition.matches(item, context)) {
            return false;
        }
        AxisIterator anc = ((NodeInfo)item).iterateAxis(1);
        NodeInfo top = (NodeInfo)item;
        while (true) {
            NodeInfo a;
            if ((a = anc.next()) == null) {
                if (this.topNodeEquivalent != null && UType.CHILD_NODE_KINDS.matches(top)) {
                    if (this.equivalentTopNodeEvaluator == null) {
                        this.equivalentTopNodeEvaluator = this.topNodeEquivalent.makeElaborator().elaborateForPull();
                    }
                    return this.isSelected((NodeInfo)item, top, this.equivalentTopNodeEvaluator, context);
                }
                return false;
            }
            if (this.matchesBeneathAnchor((NodeInfo)item, a, context)) {
                return true;
            }
            top = a;
        }
    }

    @Override
    public boolean matchesBeneathAnchor(NodeInfo node, NodeInfo anchor, XPathContext context) throws XPathException {
        if (!this.itemType.test(node)) {
            return false;
        }
        if (anchor == null) {
            NodeInfo ancestor;
            AxisIterator ancestors = node.iterateAxis(1);
            do {
                if ((ancestor = ancestors.next()) != null) continue;
                return false;
            } while (!this.matchesBeneathAnchor(node, ancestor, context));
            return true;
        }
        if (this.equivalentExprEvaluator == null) {
            this.equivalentExprEvaluator = this.equivalentExpr.makeElaborator().elaborateForPull();
        }
        return this.isSelected(node, anchor, this.equivalentExprEvaluator, context);
    }

    private boolean isSelected(NodeInfo node, NodeInfo anchor, PullEvaluator selector, XPathContext context) throws XPathException {
        XPathContextMinor c2 = context.newMinorContext();
        ManualIterator iter = new ManualIterator(anchor);
        c2.setCurrentIterator(iter);
        try {
            NodeInfo n;
            SequenceIterator nsv = selector.iterate(c2);
            do {
                if ((n = (NodeInfo)nsv.next()) != null) continue;
                return false;
            } while (!n.equals(node));
            return true;
        }
        catch (XPathException.Circularity | XPathException.StackOverflow e) {
            throw e;
        }
        catch (XPathException e) {
            this.handleDynamicError(e, c2);
            return false;
        }
    }

    @Override
    public UType getUType() {
        return this.itemType.getUType();
    }

    @Override
    public int getFingerprint() {
        return this.itemType.getFingerprint();
    }

    @Override
    public ItemType getItemType() {
        return this.itemType;
    }

    public Expression getEquivalentExpr() {
        return this.equivalentExpr;
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof GeneralNodePattern) {
            GeneralNodePattern lpp = (GeneralNodePattern)other;
            return this.equivalentExpr.isEqual(lpp.equivalentExpr);
        }
        return false;
    }

    @Override
    protected int computeHashCode() {
        return 0x146B9 ^ this.equivalentExpr.hashCode();
    }

    @Override
    public Pattern copy(RebindingMap rebindings) {
        GeneralNodePattern n = new GeneralNodePattern(this.equivalentExpr.copy(rebindings), this.itemType);
        ExpressionTool.copyLocationInfo(this, n);
        n.setOriginalText(this.getOriginalText());
        n.topNodeEquivalent = this.topNodeEquivalent == null ? null : this.topNodeEquivalent.copy(rebindings);
        n.precondition = this.precondition;
        return n;
    }

    @Override
    public void export(ExpressionPresenter presenter) throws XPathException {
        presenter.startElement("p.genNode");
        presenter.emitAttribute("test", AlphaCode.fromItemType(this.itemType));
        this.equivalentExpr.export(presenter);
        presenter.endElement();
    }
}

