/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.http.server.http2;

import org.glassfish.grizzly.ThreadCache;
import org.glassfish.grizzly.filterchain.FilterChainEvent;
import org.glassfish.grizzly.http.HttpHeader;
import org.glassfish.grizzly.http.HttpRequestPacket;
import org.glassfish.grizzly.http.Method;
import org.glassfish.grizzly.http.server.http2.PushBuilder;
import org.glassfish.grizzly.http.util.MimeHeaders;

public class PushEvent
implements FilterChainEvent {
    private static final ThreadCache.CachedTypeIndex<PushEvent> CACHE_IDX = ThreadCache.obtainIndex(PushEvent.class, (int)8);
    public static final Object TYPE = PushEvent.class.getName();
    private Method method;
    private MimeHeaders headers = new MimeHeaders();
    private String path;
    private HttpRequestPacket httpRequest;

    private PushEvent() {
    }

    public Object type() {
        return TYPE;
    }

    public static PushEvent create(PushBuilder builder) {
        PushEvent pushEvent = (PushEvent)ThreadCache.takeFromCache(CACHE_IDX);
        if (pushEvent == null) {
            pushEvent = new PushEvent();
        }
        return pushEvent.init(builder);
    }

    public Method getMethod() {
        return this.method;
    }

    public MimeHeaders getHeaders() {
        return this.headers;
    }

    public String getPath() {
        return this.path;
    }

    public HttpHeader getHttpRequest() {
        return this.httpRequest;
    }

    public void recycle() {
        this.method = null;
        this.headers.recycle();
        this.path = null;
        this.httpRequest = null;
        ThreadCache.putToCache(CACHE_IDX, (Object)this);
    }

    public static PushEventBuilder builder() {
        return new PushEventBuilder();
    }

    private static PushEvent create(PushEventBuilder builder) {
        PushEvent pushEvent = (PushEvent)ThreadCache.takeFromCache(CACHE_IDX);
        if (pushEvent == null) {
            pushEvent = new PushEvent();
        }
        return pushEvent.init(builder);
    }

    private PushEvent init(PushBuilder builder) {
        this.method = builder.method;
        this.headers.copyFrom(builder.headers);
        this.path = builder.path;
        this.httpRequest = builder.request.getRequest();
        return this;
    }

    private PushEvent init(PushEventBuilder builder) {
        this.method = builder.method;
        this.headers.copyFrom(builder.headers);
        this.path = builder.path;
        this.httpRequest = builder.httpRequest;
        return this;
    }

    public static final class PushEventBuilder {
        private Method method = Method.GET;
        private MimeHeaders headers = new MimeHeaders();
        private String path;
        private HttpRequestPacket httpRequest;

        private PushEventBuilder() {
        }

        public PushEventBuilder method(Method val) {
            if (this.method == null) {
                throw new NullPointerException();
            }
            if (!Method.GET.equals(val) && !Method.HEAD.equals(val)) {
                throw new IllegalArgumentException();
            }
            this.method = val;
            return this;
        }

        public PushEventBuilder headers(MimeHeaders val) {
            if (val == null) {
                throw new NullPointerException();
            }
            this.headers.copyFrom(val);
            return this;
        }

        public PushEventBuilder path(String val) {
            this.path = PushEventBuilder.validate(val);
            return this;
        }

        public PushEventBuilder httpRequest(HttpRequestPacket val) {
            if (val == null) {
                throw new NullPointerException();
            }
            this.httpRequest = val;
            return this;
        }

        public PushEvent build() {
            if (this.path == null || this.httpRequest == null || this.headers == null) {
                throw new IllegalArgumentException();
            }
            return PushEvent.create(this);
        }

        private static String validate(String val) {
            return val != null && !val.isEmpty() ? val : null;
        }
    }
}

