/*
 * Decompiled with CFR 0.152.
 */
package org.mule.metadata.persistence.type.adapter;

import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

final class OnlyOneFieldTypeAdapter<T>
extends TypeAdapter<T> {
    private static final int FIRST_PARAMETER = 0;
    private static final int FIRST_FIELD = 0;
    private final Gson gson;
    private final Class<T> annotationType;
    private Field fieldToSerialize;

    OnlyOneFieldTypeAdapter(Gson gson, Class<T> annotationType) {
        this.gson = gson;
        this.annotationType = annotationType;
        this.fieldToSerialize = this.getFieldToSerialize(annotationType);
    }

    public void write(JsonWriter out, T value) throws IOException {
        try {
            this.gson.toJson(this.getFieldValue(value, this.fieldToSerialize), this.fieldToSerialize.getType(), out);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(String.format("An unexpected error occurred serializing %s", value), e);
        }
    }

    public T read(JsonReader in) throws IOException {
        try {
            Constructor<T> declaredConstructor = this.annotationType.getDeclaredConstructor(this.fieldToSerialize.getType());
            Object field = this.gson.fromJson(in, this.fieldToSerialize.getType());
            return declaredConstructor.newInstance(field);
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("An unexpected error occurred serializing %s", this.fieldToSerialize), e);
        }
    }

    private Object getFieldValue(Object annotation, Field annotationField) throws IllegalAccessException {
        annotationField.setAccessible(true);
        return annotationField.get(annotation);
    }

    private Field getFieldToSerialize(Class<T> annotationType) {
        List instanceFields = Arrays.asList(annotationType.getDeclaredFields()).stream().filter(field -> !Modifier.isStatic(field.getModifiers())).collect(Collectors.toList());
        if (instanceFields.size() != 1) {
            throw new IllegalArgumentException(String.format("The class '%s' contains more than one serializable field", annotationType.getName()));
        }
        Field fieldToSerialize = (Field)instanceFields.get(0);
        long constructorsCount = Arrays.asList(annotationType.getDeclaredConstructors()).stream().filter(constructor -> constructor.getParameterCount() == 1).filter(constructor -> constructor.getParameters()[0].getType().equals(fieldToSerialize.getType())).count();
        if (constructorsCount != 1L) {
            throw new IllegalArgumentException(String.format("The class '%s' requires a constructor with an unique parameter of type '%s", annotationType.getName(), fieldToSerialize));
        }
        return fieldToSerialize;
    }
}

