/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.api.notification;

import java.io.Serializable;
import java.util.Optional;
import org.mule.api.annotation.Experimental;
import org.mule.runtime.api.notification.AbstractServerNotification;

@Experimental
public class PollingSourceItemNotification
extends AbstractServerNotification {
    public static final int ITEM_DISPATCHED = 2304;
    public static final int ITEM_REJECTED_SOURCE_STOPPING = 2305;
    public static final int ITEM_REJECTED_IDEMPOTENCY = 2306;
    public static final int ITEM_REJECTED_WATERMARK = 2307;
    private final String pollId;
    private final String itemId;
    private final Serializable watermark;
    private final String eventId;

    public PollingSourceItemNotification(int action, String pollId, String itemId, Serializable watermark, String eventId, String componentLocation) {
        super("", action, componentLocation);
        this.pollId = pollId;
        this.itemId = itemId;
        this.watermark = watermark;
        this.eventId = eventId;
    }

    public String getPollId() {
        return this.pollId;
    }

    public String getItemId() {
        return this.itemId;
    }

    public Optional<Serializable> getWatermark() {
        return Optional.ofNullable(this.watermark);
    }

    public Optional<String> getEventId() {
        return Optional.ofNullable(this.eventId);
    }

    @Override
    public String getEventName() {
        return "PollingSourceItemNotification";
    }

    static {
        PollingSourceItemNotification.registerAction("Item dispatched to flow", 2304);
        PollingSourceItemNotification.registerAction("Item rejected because the source is stopping", 2305);
        PollingSourceItemNotification.registerAction("Item rejected due to idempotency", 2306);
        PollingSourceItemNotification.registerAction("Item rejected due to watermark", 2307);
    }
}

