/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.transaction;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.InvalidTransactionException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import org.mule.api.annotation.NoExtend;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.notification.NotificationDispatcher;
import org.mule.runtime.api.tx.MuleXaObject;
import org.mule.runtime.api.tx.TransactionException;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.config.i18n.CoreMessages;
import org.mule.runtime.core.api.transaction.TransactionRollbackException;
import org.mule.runtime.core.api.transaction.TransactionStatusException;
import org.mule.runtime.core.internal.transaction.AbstractTransaction;
import org.mule.runtime.core.internal.transaction.xa.IllegalTransactionStateException;
import org.mule.runtime.core.internal.transaction.xa.XaResourceFactoryHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NoExtend
public class XaTransaction
extends AbstractTransaction {
    private static final Logger LOGGER = LoggerFactory.getLogger(XaTransaction.class);
    protected Transaction transaction = null;
    private final Map<ResourceKey, Object> resources = new HashMap<ResourceKey, Object>();
    protected TransactionManager txManager;

    public XaTransaction(String applicationName, TransactionManager transactionManager, NotificationDispatcher notificationFirer) {
        super(applicationName, notificationFirer);
        this.txManager = transactionManager;
    }

    @Deprecated
    public XaTransaction(MuleContext muleContext) {
        super(muleContext);
        this.txManager = muleContext.getTransactionManager();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doBegin() throws TransactionException {
        if (this.txManager == null) {
            throw new IllegalStateException(CoreMessages.objectNotRegistered("javax.transaction.TransactionManager", "Transaction Manager").getMessage());
        }
        try {
            this.txManager.setTransactionTimeout(this.getTimeoutInSeconds());
            this.txManager.begin();
            XaTransaction xaTransaction = this;
            synchronized (xaTransaction) {
                this.transaction = this.txManager.getTransaction();
            }
        }
        catch (Exception e) {
            throw new TransactionException(CoreMessages.cannotStartTransaction("XA"), (Throwable)e);
        }
    }

    @Override
    protected synchronized void doCommit() throws TransactionException {
        try {
            this.delistResources();
            this.txManager.commit();
        }
        catch (HeuristicRollbackException | RollbackException e) {
            throw new TransactionRollbackException(CoreMessages.transactionMarkedForRollback(), e);
        }
        catch (Exception e) {
            throw new IllegalTransactionStateException(CoreMessages.transactionCommitFailed(), e);
        }
        finally {
            this.transaction = null;
            this.closeResources();
        }
    }

    @Override
    protected void doRollback() throws TransactionRollbackException {
        try {
            this.txManager.rollback();
        }
        catch (Exception e) {
            throw new TransactionRollbackException(e);
        }
        finally {
            this.transaction = null;
            this.closeResources();
        }
    }

    @Override
    public synchronized int getStatus() throws TransactionStatusException {
        if (this.transaction == null) {
            return 6;
        }
        try {
            return this.transaction.getStatus();
        }
        catch (SystemException e) {
            throw new TransactionStatusException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setRollbackOnly() {
        if (this.transaction == null) {
            throw new IllegalStateException("Current thread is not associated with a transaction.");
        }
        try {
            XaTransaction xaTransaction = this;
            synchronized (xaTransaction) {
                this.transaction.setRollbackOnly();
            }
        }
        catch (SystemException e) {
            throw (IllegalStateException)new IllegalStateException("Failed to set transaction to rollback only: " + e.getMessage()).initCause(e);
        }
    }

    @Override
    public synchronized Object getResource(Object key) {
        ResourceKey normalizedKey = this.getResourceEntry(key);
        return this.resources.get(normalizedKey);
    }

    @Override
    public synchronized boolean hasResource(Object key) {
        ResourceKey normalizedKey = this.getResourceEntry(key);
        return this.resources.containsKey(normalizedKey);
    }

    @Override
    public synchronized void bindResource(Object key, Object resource) throws TransactionException {
        ResourceKey normalizedKey = this.getResourceEntry(key, resource);
        if (this.resources.containsKey(key)) {
            throw new IllegalTransactionStateException(CoreMessages.transactionResourceAlreadyListedForKey(key));
        }
        this.resources.put(normalizedKey, resource);
        if (key == null) {
            LOGGER.error("Key for bound resource " + resource + " is null");
        }
        if (resource instanceof MuleXaObject) {
            MuleXaObject xaObject = (MuleXaObject)resource;
            xaObject.enlist();
        } else if (resource instanceof XAResource) {
            this.enlistResource((XAResource)resource);
        } else {
            LOGGER.error("Bound resource " + resource + " is neither a MuleXaObject nor XAResource");
        }
    }

    public boolean enlistResource(XAResource resource) throws TransactionException {
        try {
            Transaction jtaTransaction = this.txManager.getTransaction();
            if (jtaTransaction == null) {
                throw new TransactionException(I18nMessageFactory.createStaticMessage((String)"XATransaction is null"));
            }
            resource.setTransactionTimeout(this.getTimeoutInSeconds());
            return jtaTransaction.enlistResource(resource);
        }
        catch (RollbackException | SystemException | XAException e) {
            throw new TransactionException(e);
        }
    }

    private int getTimeoutInSeconds() {
        return this.getTimeout() / 1000;
    }

    public boolean delistResource(XAResource resource, int tmflag) throws TransactionException {
        try {
            Transaction jtaTransaction = this.txManager.getTransaction();
            if (jtaTransaction == null) {
                throw new TransactionException(CoreMessages.noJtaTransactionAvailable(Thread.currentThread()));
            }
            return jtaTransaction.delistResource(resource, tmflag);
        }
        catch (SystemException e) {
            throw new TransactionException((Throwable)e);
        }
    }

    @Override
    public String toString() {
        return this.transaction == null ? " <n/a>" : this.transaction.toString();
    }

    public Transaction getTransaction() {
        return this.transaction;
    }

    @Override
    public boolean isXA() {
        return true;
    }

    @Override
    public void resume() throws TransactionException {
        if (this.txManager == null) {
            throw new IllegalStateException(CoreMessages.objectNotRegistered("javax.transaction.TransactionManager", "Transaction Manager").getMessage());
        }
        try {
            this.txManager.resume(this.transaction);
        }
        catch (InvalidTransactionException | SystemException e) {
            throw new TransactionException(e);
        }
    }

    @Override
    public Transaction suspend() throws TransactionException {
        if (this.txManager == null) {
            throw new IllegalStateException(CoreMessages.objectNotRegistered("javax.transaction.TransactionManager", "Transaction Manager").getMessage());
        }
        try {
            this.transaction = this.txManager.suspend();
        }
        catch (SystemException e) {
            throw new TransactionException((Throwable)e);
        }
        return this.transaction;
    }

    protected synchronized void delistResources() {
        for (Map.Entry<ResourceKey, Object> o : this.resources.entrySet()) {
            Map.Entry<ResourceKey, Object> entry = o;
            Object xaObject = entry.getValue();
            if (!(xaObject instanceof MuleXaObject)) continue;
            try {
                ((MuleXaObject)xaObject).delist();
            }
            catch (Exception e) {
                LOGGER.error("Failed to delist resource " + xaObject, (Throwable)e);
            }
        }
    }

    protected synchronized void closeResources() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("About to close {} resources for XA tx {}...", (Object)this.resources.size(), (Object)this.toString());
        }
        Iterator<Map.Entry<ResourceKey, Object>> i = this.resources.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry<ResourceKey, Object> entry = i.next();
            Object value = entry.getValue();
            if (value instanceof MuleXaObject) {
                MuleXaObject xaObject = (MuleXaObject)value;
                if (!xaObject.isReuseObject()) {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("About to close resource {}...", (Object)xaObject);
                    }
                    try {
                        xaObject.close();
                        i.remove();
                    }
                    catch (Exception e) {
                        LOGGER.error("Failed to close resource " + xaObject, (Throwable)e);
                    }
                    continue;
                }
                if (!LOGGER.isDebugEnabled()) continue;
                LOGGER.debug("Not closing reusable object {}", (Object)xaObject);
                continue;
            }
            if (!LOGGER.isDebugEnabled()) continue;
            LOGGER.debug("Not closing non-MuleXaObject object {}", value);
        }
    }

    @Override
    public boolean supports(Object key, Object resource) {
        return resource instanceof XAResource || resource instanceof MuleXaObject;
    }

    private ResourceKey getResourceEntry(Object resourceFactory) {
        resourceFactory = resourceFactory instanceof XaResourceFactoryHolder ? ((XaResourceFactoryHolder)resourceFactory).getHoldObject() : resourceFactory;
        return new ResourceKey(resourceFactory, null);
    }

    private ResourceKey getResourceEntry(Object resourceFactory, Object resource) {
        resourceFactory = resourceFactory instanceof XaResourceFactoryHolder ? ((XaResourceFactoryHolder)resourceFactory).getHoldObject() : resourceFactory;
        return new ResourceKey(resourceFactory, resource);
    }

    private static class ResourceKey {
        private final Object resourceFactory;
        private Object resource;

        public ResourceKey(Object resourceFactory) {
            Preconditions.checkArgument((resourceFactory != null ? 1 : 0) != 0, (String)"resourceFactory cannot be null");
            this.resourceFactory = resourceFactory;
            this.resource = null;
        }

        public ResourceKey(Object resourceFactory, Object resource) {
            this(resourceFactory);
            this.resource = resource;
        }

        public Object getResourceFactory() {
            return this.resourceFactory;
        }

        public Object getResource() {
            return this.resource;
        }

        public int hashCode() {
            return Objects.hashCode(this.resourceFactory);
        }

        public boolean equals(Object obj) {
            return this.resourceFactory.equals(((ResourceKey)obj).getResourceFactory());
        }
    }
}

