/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal.model.dsl.config;

import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.mule.runtime.config.internal.model.dsl.config.DefaultConfigurationProperty;
import org.mule.runtime.properties.api.ConfigurationPropertiesProvider;
import org.mule.runtime.properties.api.ConfigurationProperty;

public class SystemPropertiesConfigurationProvider
implements ConfigurationPropertiesProvider {
    private final Map<String, String> properties = System.getProperties().entrySet().stream().collect(Collectors.toMap(p -> p.getKey().toString(), p -> p.getValue().toString()));

    public Optional<ConfigurationProperty> provide(String configurationAttributeKey) {
        String value = this.properties.get(configurationAttributeKey);
        if (value == null) {
            return Optional.empty();
        }
        return Optional.of(new DefaultConfigurationProperty("system property", configurationAttributeKey, value));
    }

    public String getDescription() {
        return "system properties provider";
    }
}

