/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.metrics.exporter.config.impl;

import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileSystems;
import java.util.Optional;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.config.api.properties.ConfigurationPropertiesResolver;
import org.mule.runtime.config.internal.model.dsl.ClassLoaderResourceProvider;
import org.mule.runtime.config.internal.model.dsl.config.DefaultConfigurationPropertiesResolver;
import org.mule.runtime.config.internal.model.dsl.config.SystemPropertiesConfigurationProvider;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.metrics.exporter.config.api.MeterExporterConfiguration;
import org.mule.runtime.module.observability.FileConfiguration;
import org.mule.runtime.properties.api.ConfigurationPropertiesProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileMeterExporterConfiguration
extends FileConfiguration
implements MeterExporterConfiguration {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileMeterExporterConfiguration.class);
    private static final String CONFIGURATION_FILE_NAME = "meter-exporter.conf";
    private final MuleContext muleContext;
    private JsonNode configuration;
    private final ConfigurationPropertiesResolver propertyResolver = new DefaultConfigurationPropertiesResolver(Optional.empty(), (ConfigurationPropertiesProvider)new SystemPropertiesConfigurationProvider());

    public FileMeterExporterConfiguration(MuleContext muleContext) {
        super(muleContext);
        this.muleContext = muleContext;
        this.getMeterExporterProperties();
    }

    protected boolean isAValueCorrespondingToAPath(String key) {
        return key.equals("mule.openTelemetry.meter.exporter.tls.caFileLocation") || key.equals("mule.openTelemetry.meter.exporter.tls.keyFileLocation");
    }

    protected JsonNode getConfiguration() {
        return this.configuration;
    }

    protected ConfigurationPropertiesResolver getPropertyResolver() {
        return this.propertyResolver;
    }

    private void getMeterExporterProperties() {
        ClassLoaderResourceProvider resourceProvider = new ClassLoaderResourceProvider(this.getExecutionClassLoader(this.muleContext));
        try {
            InputStream is = resourceProvider.getResourceAsStream(this.resolveConfigurationFilePath());
            this.configuration = FileMeterExporterConfiguration.loadConfiguration((InputStream)is);
        }
        catch (IOException | MuleRuntimeException e) {
            LOGGER.info("No meter exporter configuration found.");
        }
    }

    private String resolveConfigurationFilePath() {
        String defaultConfigurationFilePath = this.getConfFolder() + FileSystems.getDefault().getSeparator() + this.getPropertiesFileName();
        return System.getProperty("mule.openTelemetry.meter.exporter.configurationFilePath", defaultConfigurationFilePath);
    }

    protected String getPropertiesFileName() {
        return CONFIGURATION_FILE_NAME;
    }
}

