/*
 * Decompiled with CFR 0.152.
 */
package com.ning.http.client;

import com.ning.http.client.uri.Uri;
import com.ning.http.util.AuthenticatorUtils;
import com.ning.http.util.MiscUtils;
import com.ning.http.util.StringUtils;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.concurrent.ThreadLocalRandom;

public class Realm {
    private static final String EMPTY_ENTITY_MD5 = "d41d8cd98f00b204e9800998ecf8427e";
    private static final String DEFAULT_NC = "00000001";
    private final String principal;
    private final String password;
    private final AuthScheme scheme;
    private final String realmName;
    private final String nonce;
    private final String algorithm;
    private final String response;
    private final String opaque;
    private final String qop;
    private final String nc;
    private final String cnonce;
    private final Uri uri;
    private final String methodName;
    private final boolean usePreemptiveAuth;
    private final Charset charset;
    private final String ntlmHost;
    private final boolean useAbsoluteURI;
    private final boolean omitQuery;
    private final boolean targetProxy;
    private final String ntlmDomain;

    private Realm(AuthScheme scheme, String principal, String password, String realmName, String nonce, String algorithm, String response, String qop, String nc, String cnonce, Uri uri, String method, boolean usePreemptiveAuth, String ntlmDomain, Charset charset, String ntlmHost, String opaque, boolean useAbsoluteURI, boolean omitQuery, boolean targetProxy) {
        this.principal = principal;
        this.password = password;
        this.scheme = scheme;
        this.realmName = realmName;
        this.nonce = nonce;
        this.algorithm = algorithm;
        this.response = response;
        this.opaque = opaque;
        this.qop = qop;
        this.nc = nc;
        this.cnonce = cnonce;
        this.uri = uri;
        this.methodName = method;
        this.usePreemptiveAuth = usePreemptiveAuth;
        this.ntlmDomain = ntlmDomain;
        this.charset = charset;
        this.ntlmHost = ntlmHost;
        this.useAbsoluteURI = useAbsoluteURI;
        this.omitQuery = omitQuery;
        this.targetProxy = targetProxy;
    }

    public String getPrincipal() {
        return this.principal;
    }

    public String getPassword() {
        return this.password;
    }

    public AuthScheme getScheme() {
        return this.scheme;
    }

    public String getRealmName() {
        return this.realmName;
    }

    public String getNonce() {
        return this.nonce;
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public String getResponse() {
        return this.response;
    }

    public String getOpaque() {
        return this.opaque;
    }

    public String getQop() {
        return this.qop;
    }

    public String getNc() {
        return this.nc;
    }

    public String getCnonce() {
        return this.cnonce;
    }

    public Uri getUri() {
        return this.uri;
    }

    public Charset getCharset() {
        return this.charset;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public boolean getUsePreemptiveAuth() {
        return this.usePreemptiveAuth;
    }

    public String getNtlmDomain() {
        return this.ntlmDomain;
    }

    public String getNtlmHost() {
        return this.ntlmHost;
    }

    public boolean isUseAbsoluteURI() {
        return this.useAbsoluteURI;
    }

    public boolean isOmitQuery() {
        return this.omitQuery;
    }

    public boolean isTargetProxy() {
        return this.targetProxy;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Realm realm = (Realm)o;
        if (this.algorithm != null ? !this.algorithm.equals(realm.algorithm) : realm.algorithm != null) {
            return false;
        }
        if (this.cnonce != null ? !this.cnonce.equals(realm.cnonce) : realm.cnonce != null) {
            return false;
        }
        if (this.nc != null ? !this.nc.equals(realm.nc) : realm.nc != null) {
            return false;
        }
        if (this.nonce != null ? !this.nonce.equals(realm.nonce) : realm.nonce != null) {
            return false;
        }
        if (this.password != null ? !this.password.equals(realm.password) : realm.password != null) {
            return false;
        }
        if (this.principal != null ? !this.principal.equals(realm.principal) : realm.principal != null) {
            return false;
        }
        if (this.qop != null ? !this.qop.equals(realm.qop) : realm.qop != null) {
            return false;
        }
        if (this.realmName != null ? !this.realmName.equals(realm.realmName) : realm.realmName != null) {
            return false;
        }
        if (this.response != null ? !this.response.equals(realm.response) : realm.response != null) {
            return false;
        }
        if (this.scheme != realm.scheme) {
            return false;
        }
        if (this.uri != null ? !this.uri.equals(realm.uri) : realm.uri != null) {
            return false;
        }
        if (this.useAbsoluteURI != !realm.useAbsoluteURI) {
            return false;
        }
        return this.omitQuery == !realm.omitQuery;
    }

    public String toString() {
        return "Realm{principal='" + this.principal + '\'' + ", password='" + this.password + '\'' + ", scheme=" + (Object)((Object)this.scheme) + ", realmName='" + this.realmName + '\'' + ", nonce='" + this.nonce + '\'' + ", algorithm='" + this.algorithm + '\'' + ", response='" + this.response + '\'' + ", qop='" + this.qop + '\'' + ", nc='" + this.nc + '\'' + ", cnonce='" + this.cnonce + '\'' + ", uri='" + this.uri + '\'' + ", methodName='" + this.methodName + '\'' + ", useAbsoluteURI='" + this.useAbsoluteURI + '\'' + ", omitQuery='" + this.omitQuery + '\'' + '}';
    }

    public int hashCode() {
        int result = this.principal != null ? this.principal.hashCode() : 0;
        result = 31 * result + (this.password != null ? this.password.hashCode() : 0);
        result = 31 * result + (this.scheme != null ? this.scheme.hashCode() : 0);
        result = 31 * result + (this.realmName != null ? this.realmName.hashCode() : 0);
        result = 31 * result + (this.nonce != null ? this.nonce.hashCode() : 0);
        result = 31 * result + (this.algorithm != null ? this.algorithm.hashCode() : 0);
        result = 31 * result + (this.response != null ? this.response.hashCode() : 0);
        result = 31 * result + (this.qop != null ? this.qop.hashCode() : 0);
        result = 31 * result + (this.nc != null ? this.nc.hashCode() : 0);
        result = 31 * result + (this.cnonce != null ? this.cnonce.hashCode() : 0);
        result = 31 * result + (this.uri != null ? this.uri.hashCode() : 0);
        return result;
    }

    public static enum AuthScheme {
        DIGEST,
        BASIC,
        NTLM,
        SPNEGO,
        KERBEROS,
        NONE;

    }

    public static class RealmBuilder {
        private String principal;
        private String password;
        private AuthScheme scheme = AuthScheme.NONE;
        private String realmName;
        private String nonce;
        private String algorithm;
        private String response;
        private String opaque;
        private String qop;
        private String nc = "00000001";
        private String cnonce;
        private Uri uri;
        private String methodName = "GET";
        private boolean usePreemptive = false;
        private String ntlmDomain = System.getProperty("http.auth.ntlm.domain", "");
        private Charset charset = StandardCharsets.UTF_8;
        private String ntlmHost = "localhost";
        private boolean useAbsoluteURI = false;
        private boolean omitQuery = false;
        private boolean targetProxy = false;
        private static final ThreadLocal<MessageDigest> digestThreadLocal = new ThreadLocal<MessageDigest>(){

            @Override
            protected MessageDigest initialValue() {
                try {
                    return MessageDigest.getInstance("MD5");
                }
                catch (NoSuchAlgorithmException e) {
                    throw new RuntimeException(e);
                }
            }
        };
        private static final char[] HEXADECIMAL = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

        public String getNtlmDomain() {
            return this.ntlmDomain;
        }

        public RealmBuilder setNtlmDomain(String ntlmDomain) {
            this.ntlmDomain = ntlmDomain;
            return this;
        }

        public String getNtlmHost() {
            return this.ntlmHost;
        }

        public RealmBuilder setNtlmHost(String host) {
            this.ntlmHost = host;
            return this;
        }

        public String getPrincipal() {
            return this.principal;
        }

        public RealmBuilder setPrincipal(String principal) {
            this.principal = principal;
            return this;
        }

        public String getPassword() {
            return this.password;
        }

        public RealmBuilder setPassword(String password) {
            this.password = password;
            return this;
        }

        public AuthScheme getScheme() {
            return this.scheme;
        }

        public RealmBuilder setScheme(AuthScheme scheme) {
            this.scheme = scheme;
            return this;
        }

        public String getRealmName() {
            return this.realmName;
        }

        public RealmBuilder setRealmName(String realmName) {
            this.realmName = realmName;
            return this;
        }

        public String getNonce() {
            return this.nonce;
        }

        public RealmBuilder setNonce(String nonce) {
            this.nonce = nonce;
            return this;
        }

        public String getAlgorithm() {
            return this.algorithm;
        }

        public RealmBuilder setAlgorithm(String algorithm) {
            this.algorithm = algorithm;
            return this;
        }

        public String getResponse() {
            return this.response;
        }

        public RealmBuilder setResponse(String response) {
            this.response = response;
            return this;
        }

        public String getOpaque() {
            return this.opaque;
        }

        public RealmBuilder setOpaque(String opaque) {
            this.opaque = opaque;
            return this;
        }

        public String getQop() {
            return this.qop;
        }

        public RealmBuilder setQop(String qop) {
            if (MiscUtils.isNonEmpty(qop)) {
                this.qop = qop;
            }
            return this;
        }

        public String getNc() {
            return this.nc;
        }

        public RealmBuilder setNc(String nc) {
            this.nc = nc;
            return this;
        }

        public Uri getUri() {
            return this.uri;
        }

        public RealmBuilder setUri(Uri uri) {
            this.uri = uri;
            return this;
        }

        public String getMethodName() {
            return this.methodName;
        }

        public RealmBuilder setMethodName(String methodName) {
            this.methodName = methodName;
            return this;
        }

        public boolean getUsePreemptiveAuth() {
            return this.usePreemptive;
        }

        public RealmBuilder setUsePreemptiveAuth(boolean usePreemptiveAuth) {
            this.usePreemptive = usePreemptiveAuth;
            return this;
        }

        public boolean isUseAbsoluteURI() {
            return this.useAbsoluteURI;
        }

        public RealmBuilder setUseAbsoluteURI(boolean useAbsoluteURI) {
            this.useAbsoluteURI = useAbsoluteURI;
            return this;
        }

        public boolean isOmitQuery() {
            return this.omitQuery;
        }

        public RealmBuilder setOmitQuery(boolean omitQuery) {
            this.omitQuery = omitQuery;
            return this;
        }

        public boolean isTargetProxy() {
            return this.targetProxy;
        }

        public RealmBuilder setTargetProxy(boolean targetProxy) {
            this.targetProxy = targetProxy;
            return this;
        }

        private String parseRawQop(String rawQop) {
            String[] rawServerSupportedQops = rawQop.split(",");
            String[] serverSupportedQops = new String[rawServerSupportedQops.length];
            for (int i = 0; i < rawServerSupportedQops.length; ++i) {
                serverSupportedQops[i] = rawServerSupportedQops[i].trim();
            }
            for (String rawServerSupportedQop : serverSupportedQops) {
                if (!rawServerSupportedQop.equals("auth")) continue;
                return rawServerSupportedQop;
            }
            for (String rawServerSupportedQop : serverSupportedQops) {
                if (!rawServerSupportedQop.equals("auth-int")) continue;
                return rawServerSupportedQop;
            }
            return null;
        }

        public RealmBuilder parseWWWAuthenticateHeader(String headerLine) {
            this.setRealmName(this.match(headerLine, "realm"));
            this.setNonce(this.match(headerLine, "nonce"));
            String algorithm = this.match(headerLine, "algorithm");
            if (MiscUtils.isNonEmpty(algorithm)) {
                this.setAlgorithm(algorithm);
            }
            this.setOpaque(this.match(headerLine, "opaque"));
            String rawQop = this.match(headerLine, "qop");
            if (rawQop != null) {
                this.setQop(this.parseRawQop(rawQop));
            }
            if (MiscUtils.isNonEmpty(this.getNonce())) {
                this.setScheme(AuthScheme.DIGEST);
            } else {
                this.setScheme(AuthScheme.BASIC);
            }
            return this;
        }

        public RealmBuilder parseProxyAuthenticateHeader(String headerLine) {
            this.setRealmName(this.match(headerLine, "realm"));
            this.setNonce(this.match(headerLine, "nonce"));
            this.setOpaque(this.match(headerLine, "opaque"));
            String algorithm = this.match(headerLine, "algorithm");
            if (MiscUtils.isNonEmpty(algorithm)) {
                this.setAlgorithm(algorithm);
            }
            this.setQop(this.match(headerLine, "qop"));
            if (MiscUtils.isNonEmpty(this.getNonce())) {
                this.setScheme(AuthScheme.DIGEST);
            } else {
                this.setScheme(AuthScheme.BASIC);
            }
            this.setTargetProxy(true);
            return this;
        }

        public RealmBuilder clone(Realm clone) {
            return this.setRealmName(clone.getRealmName()).setAlgorithm(clone.getAlgorithm()).setMethodName(clone.getMethodName()).setNc(clone.getNc()).setNonce(clone.getNonce()).setPassword(clone.getPassword()).setPrincipal(clone.getPrincipal()).setCharset(clone.getCharset()).setOpaque(clone.getOpaque()).setQop(clone.getQop()).setScheme(clone.getScheme()).setUri(clone.getUri()).setUsePreemptiveAuth(clone.getUsePreemptiveAuth()).setNtlmDomain(clone.getNtlmDomain()).setNtlmHost(clone.getNtlmHost()).setUseAbsoluteURI(clone.isUseAbsoluteURI()).setOmitQuery(clone.isOmitQuery()).setTargetProxy(clone.isTargetProxy());
        }

        private void newCnonce(MessageDigest md) {
            byte[] b = new byte[8];
            ThreadLocalRandom.current().nextBytes(b);
            b = md.digest(b);
            this.cnonce = RealmBuilder.toHexString(b);
        }

        private String match(String headerLine, String token) {
            if (headerLine == null) {
                return null;
            }
            int match = headerLine.indexOf(token);
            if (match <= 0) {
                return null;
            }
            int traillingComa = headerLine.indexOf(",", match += token.length() + 1);
            String value = headerLine.substring(match, traillingComa > 0 ? traillingComa : headerLine.length());
            value = value.endsWith("\"") ? value.substring(0, value.length() - 1) : value;
            return value.startsWith("\"") ? value.substring(1) : value;
        }

        public Charset getCharset() {
            return this.charset;
        }

        public RealmBuilder setCharset(Charset charset) {
            this.charset = charset;
            return this;
        }

        private byte[] md5FromRecycledStringBuilder(StringBuilder sb, MessageDigest md) {
            md.update(StringUtils.charSequence2ByteBuffer(sb, StandardCharsets.ISO_8859_1));
            sb.setLength(0);
            return md.digest();
        }

        private byte[] secretDigest(StringBuilder sb, MessageDigest md) {
            sb.append(this.principal).append(':').append(this.realmName).append(':').append(this.password);
            byte[] ha1 = this.md5FromRecycledStringBuilder(sb, md);
            if (this.algorithm == null || this.algorithm.equals("MD5")) {
                return ha1;
            }
            if ("MD5-sess".equals(this.algorithm)) {
                RealmBuilder.appendBase16(sb, ha1);
                sb.append(':').append(this.nonce).append(':').append(this.cnonce);
                return this.md5FromRecycledStringBuilder(sb, md);
            }
            throw new UnsupportedOperationException("Digest algorithm not supported: " + this.algorithm);
        }

        private byte[] dataDigest(StringBuilder sb, String digestUri, MessageDigest md) {
            sb.append(this.methodName).append(':').append(digestUri);
            if ("auth-int".equals(this.qop)) {
                sb.append(':').append(Realm.EMPTY_ENTITY_MD5);
            } else if (this.qop != null && !this.qop.equals("auth")) {
                throw new UnsupportedOperationException("Digest qop not supported: " + this.qop);
            }
            return this.md5FromRecycledStringBuilder(sb, md);
        }

        private void appendDataBase(StringBuilder sb) {
            sb.append(':').append(this.nonce).append(':');
            if ("auth".equals(this.qop) || "auth-int".equals(this.qop)) {
                sb.append(this.nc).append(':').append(this.cnonce).append(':').append(this.qop).append(':');
            }
        }

        private void newResponse(MessageDigest md) {
            String digestUri = AuthenticatorUtils.computeRealmURI(this.uri, this.useAbsoluteURI, this.omitQuery);
            StringBuilder sb = StringUtils.stringBuilder();
            byte[] secretDigest = this.secretDigest(sb, md);
            byte[] dataDigest = this.dataDigest(sb, digestUri, md);
            RealmBuilder.appendBase16(sb, secretDigest);
            this.appendDataBase(sb);
            RealmBuilder.appendBase16(sb, dataDigest);
            byte[] responseDigest = this.md5FromRecycledStringBuilder(sb, md);
            this.response = RealmBuilder.toHexString(responseDigest);
        }

        private static String toHexString(byte[] data) {
            StringBuilder sb = StringUtils.stringBuilder();
            RealmBuilder.appendBase16(sb, data);
            String hex = sb.toString();
            sb.setLength(0);
            return hex;
        }

        private static void appendBase16(StringBuilder buf, byte[] bytes) {
            for (int i = 0; i < bytes.length; ++i) {
                int low = bytes[i] & 0xF;
                int high = (bytes[i] & 0xF0) >> 4;
                buf.append(HEXADECIMAL[high]);
                buf.append(HEXADECIMAL[low]);
            }
        }

        public Realm build() {
            if (MiscUtils.isNonEmpty(this.nonce)) {
                MessageDigest md = digestThreadLocal.get();
                this.newCnonce(md);
                this.newResponse(md);
            }
            return new Realm(this.scheme, this.principal, this.password, this.realmName, this.nonce, this.algorithm, this.response, this.qop, this.nc, this.cnonce, this.uri, this.methodName, this.usePreemptive, this.ntlmDomain, this.charset, this.ntlmHost, this.opaque, this.useAbsoluteURI, this.omitQuery, this.targetProxy);
        }
    }
}

