/*
 * Decompiled with CFR 0.152.
 */
package org.mule.mvel2.ast;

import java.util.ArrayList;
import java.util.Collection;
import org.mule.mvel2.CompileException;
import org.mule.mvel2.ParserContext;
import org.mule.mvel2.ast.ASTNode;
import org.mule.mvel2.compiler.ExecutableStatement;
import org.mule.mvel2.integration.VariableResolverFactory;
import org.mule.mvel2.integration.impl.DefaultLocalVariableResolverFactory;
import org.mule.mvel2.integration.impl.ItemResolverFactory;
import org.mule.mvel2.util.CompilerTools;
import org.mule.mvel2.util.ParseTools;

public class Fold
extends ASTNode {
    private ExecutableStatement subEx;
    private ExecutableStatement dataEx;
    private ExecutableStatement constraintEx;

    public Fold(char[] expr, int start, int offset, int fields, ParserContext pCtx) {
        super(pCtx);
        int cursor;
        this.expr = expr;
        this.start = start;
        this.offset = offset;
        int end = start + offset;
        for (cursor = start; cursor < end; ++cursor) {
            if (!ParseTools.isWhitespace(expr[cursor])) continue;
            while (cursor < end && ParseTools.isWhitespace(expr[cursor])) {
                ++cursor;
            }
            if (expr[cursor] == 'i' && expr[cursor + 1] == 'n' && ParseTools.isJunct(expr[cursor + 2])) break;
        }
        this.subEx = (ExecutableStatement)ParseTools.subCompileExpression(expr, start, cursor - start - 1, pCtx);
        int st = cursor += 2;
        while (cursor < end) {
            if (ParseTools.isWhitespace(expr[cursor])) {
                while (cursor < end && ParseTools.isWhitespace(expr[cursor])) {
                    ++cursor;
                }
                if (expr[cursor] == 'i' && expr[cursor + 1] == 'f' && ParseTools.isJunct(expr[cursor + 2])) {
                    int s = cursor + 2;
                    this.constraintEx = (ExecutableStatement)ParseTools.subCompileExpression(expr, s, end - s, pCtx);
                    break;
                }
            }
            ++cursor;
        }
        while (ParseTools.isWhitespace(expr[cursor])) {
            --cursor;
        }
        this.dataEx = (ExecutableStatement)ParseTools.subCompileExpression(expr, st, cursor - st, pCtx);
        CompilerTools.expectType(this.dataEx, Collection.class, (fields & 0x10) != 0);
    }

    public Object getReducedValueAccelerated(Object ctx, Object thisValue, VariableResolverFactory factory) {
        ArrayList<Object> list;
        ItemResolverFactory.ItemResolver itemR = new ItemResolverFactory.ItemResolver("$");
        ItemResolverFactory itemFactory = new ItemResolverFactory(itemR, new DefaultLocalVariableResolverFactory(factory));
        if (this.constraintEx != null) {
            Collection col = (Collection)this.dataEx.getValue(ctx, thisValue, factory);
            list = new ArrayList<Object>(col.size());
            for (Object o : col) {
                itemR.value = o;
                if (!((Boolean)this.constraintEx.getValue(ctx, thisValue, itemFactory)).booleanValue()) continue;
                list.add(this.subEx.getValue(o, thisValue, itemFactory));
            }
        } else {
            Collection col = (Collection)this.dataEx.getValue(ctx, thisValue, factory);
            list = new ArrayList(col.size());
            for (Object o : col) {
                itemR.value = o;
                list.add(this.subEx.getValue(itemR.value, thisValue, itemFactory));
            }
        }
        return list;
    }

    public Object getReducedValue(Object ctx, Object thisValue, VariableResolverFactory factory) {
        ArrayList<Object> list;
        ItemResolverFactory.ItemResolver itemR = new ItemResolverFactory.ItemResolver("$");
        ItemResolverFactory itemFactory = new ItemResolverFactory(itemR, new DefaultLocalVariableResolverFactory(factory));
        if (this.constraintEx != null) {
            Object x = this.dataEx.getValue(ctx, thisValue, factory);
            if (!(x instanceof Collection)) {
                throw new CompileException("was expecting type: Collection; but found type: " + (x == null ? "null" : x.getClass().getName()), this.expr, this.start);
            }
            list = new ArrayList<Object>(((Collection)x).size());
            for (Object o : (Collection)x) {
                itemR.value = o;
                if (!((Boolean)this.constraintEx.getValue(ctx, thisValue, itemFactory)).booleanValue()) continue;
                list.add(this.subEx.getValue(o, thisValue, itemFactory));
            }
        } else {
            Object x = this.dataEx.getValue(ctx, thisValue, factory);
            if (!(x instanceof Collection)) {
                throw new CompileException("was expecting type: Collection; but found type: " + (x == null ? "null" : x.getClass().getName()), this.expr, this.start);
            }
            list = new ArrayList(((Collection)x).size());
            for (Object o : (Collection)x) {
                itemR.value = o;
                list.add(this.subEx.getValue(itemR.value, thisValue, itemFactory));
            }
        }
        return list;
    }

    public Class getEgressType() {
        return Collection.class;
    }
}

