/*
 * Decompiled with CFR 0.152.
 */
package org.everit.json.schema;

import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.everit.json.schema.ObjectComparator;
import org.everit.json.schema.Schema;
import org.everit.json.schema.ValidationException;
import org.everit.json.schema.internal.JSONPrinter;

public class EnumSchema
extends Schema {
    private final Set<Object> possibleValues;

    public static Builder builder() {
        return new Builder();
    }

    public EnumSchema(Builder builder) {
        super(builder);
        this.possibleValues = Collections.unmodifiableSet(new HashSet(builder.possibleValues));
    }

    public Set<Object> getPossibleValues() {
        return this.possibleValues;
    }

    @Override
    public void validate(Object subject) {
        this.possibleValues.stream().filter(val -> ObjectComparator.deepEquals(val, subject)).findAny().orElseThrow(() -> new ValidationException((Schema)this, String.format("%s is not a valid enum value", subject), "enum"));
    }

    @Override
    void describePropertiesTo(JSONPrinter writer) {
        writer.key("type");
        writer.value("enum");
        writer.key("enum");
        writer.array();
        this.possibleValues.forEach(writer::value);
        writer.endArray();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof EnumSchema) {
            EnumSchema that = (EnumSchema)o;
            return that.canEqual(this) && Objects.equals(this.possibleValues, that.possibleValues) && super.equals(that);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.possibleValues);
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof EnumSchema;
    }

    public static class Builder
    extends Schema.Builder<EnumSchema> {
        private Set<Object> possibleValues = new HashSet<Object>();

        @Override
        public EnumSchema build() {
            return new EnumSchema(this);
        }

        public Builder possibleValue(Object possibleValue) {
            this.possibleValues.add(possibleValue);
            return this;
        }

        public Builder possibleValues(Set<Object> possibleValues) {
            this.possibleValues = possibleValues;
            return this;
        }
    }
}

