/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal.validation;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.mule.metadata.api.model.MetadataType;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.component.TypedComponentIdentifier;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.ast.api.ArtifactAst;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.ast.api.ComponentGenerationInformation;
import org.mule.runtime.ast.api.ComponentMetadataAst;
import org.mule.runtime.ast.api.ComponentParameterAst;
import org.mule.runtime.ast.api.util.BaseComponentAst;
import org.mule.runtime.ast.api.validation.ArtifactValidation;
import org.mule.runtime.ast.api.validation.Validation;
import org.mule.runtime.ast.api.validation.ValidationResultItem;

public class ImportValidTarget
implements ArtifactValidation {
    public String getName() {
        return "Imported files exist";
    }

    public String getDescription() {
        return "Import elements in config files point to actual and valid files.";
    }

    public Validation.Level getLevel() {
        return Validation.Level.ERROR;
    }

    public List<ValidationResultItem> validateMany(ArtifactAst artifact) {
        return artifact.getImportedResources().stream().filter(imp -> imp.getResolutionFailure().isPresent()).map(imp -> {
            String message = (String)imp.getResolutionFailure().get();
            return ValidationResultItem.create((ComponentAst)new ImportComponentAst(imp.getMetadata()), (Validation)this, (String)message, (boolean)message.startsWith("Could not resolve imported resource "));
        }).collect(Collectors.toList());
    }

    public Predicate<List<ComponentAst>> applicable() {
        return h -> true;
    }

    public Optional<ValidationResultItem> validate(ComponentAst component, ArtifactAst artifact) {
        return this.validate(artifact);
    }

    private static final class ImportComponentAst
    extends BaseComponentAst {
        private final ComponentMetadataAst metadata;

        public ImportComponentAst(ComponentMetadataAst metadata) {
            this.metadata = metadata;
        }

        public ComponentMetadataAst getMetadata() {
            return this.metadata;
        }

        public MetadataType getType() {
            return null;
        }

        public Collection<ComponentParameterAst> getParameters() {
            return Collections.emptyList();
        }

        public <M> Optional<M> getModel(Class<M> modelClass) {
            return Optional.empty();
        }

        public ComponentLocation getLocation() {
            return null;
        }

        public ComponentIdentifier getIdentifier() {
            return ComponentIdentifier.builder().namespace("mule").name("import").build();
        }

        public ComponentGenerationInformation getGenerationInformation() {
            return null;
        }

        public ExtensionModel getExtensionModel() {
            return null;
        }

        public TypedComponentIdentifier.ComponentType getComponentType() {
            return TypedComponentIdentifier.ComponentType.UNKNOWN;
        }

        public Optional<String> getComponentId() {
            return Optional.empty();
        }

        public Map<String, Object> getAnnotations() {
            return Collections.emptyMap();
        }

        public List<ComponentAst> directChildren() {
            return Collections.emptyList();
        }
    }
}

