/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.scheduler.internal;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TimeZone;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.profiling.ProfilingService;
import org.mule.service.scheduler.ThreadType;
import org.mule.service.scheduler.internal.AbstractRunnableFutureDecorator;
import org.mule.service.scheduler.internal.NullScheduledFuture;
import org.mule.service.scheduler.internal.QuartzCronJob;
import org.mule.service.scheduler.internal.QuartzScheduledFuture;
import org.mule.service.scheduler.internal.RepeatableTaskWrapper;
import org.mule.service.scheduler.internal.RunnableFutureDecorator;
import org.mule.service.scheduler.internal.RunnableRepeatableFutureDecorator;
import org.mule.service.scheduler.internal.ScheduledFutureDecorator;
import org.mule.service.scheduler.internal.logging.SuppressingLogger;
import org.quartz.CronScheduleBuilder;
import org.quartz.CronTrigger;
import org.quartz.JobBuilder;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultScheduler
extends AbstractExecutorService
implements org.mule.runtime.api.scheduler.Scheduler {
    private static final Runnable EMPTY_RUNNABLE = () -> {};
    private static final long FORCEFUL_SHUTDOWN_TIMEOUT_SECS = 5L;
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultScheduler.class);
    private final AtomicInteger idGenerator = new AtomicInteger(0);
    private final String name;
    private final ExecutorService executor;
    private final ScheduledExecutorService scheduledExecutor;
    private final Scheduler quartzScheduler;
    private final ThreadType threadType;
    private Class<? extends QuartzCronJob> jobClass = QuartzCronJob.class;
    private final CountDownLatch terminationLatch = new CountDownLatch(1);
    private static final ScheduledFuture<?> NULL_SCHEDULED_FUTURE = NullScheduledFuture.INSTANCE;
    private final Map<RunnableFuture<?>, ScheduledFuture<?>> scheduledTasks;
    private final ReadWriteLock shutdownLock = new ReentrantReadWriteLock();
    private volatile boolean shutdown = false;
    private ProfilingService profilingService;
    protected Supplier<Long> shutdownTimeoutMillis;
    protected final Consumer<org.mule.runtime.api.scheduler.Scheduler> shutdownCallback;
    private final SuppressingLogger schedulableSuppressionLogger;

    public DefaultScheduler(String name, ExecutorService executor, int parallelTasksEstimate, ScheduledExecutorService scheduledExecutor, Scheduler quartzScheduler, ThreadType threadsType, Supplier<Long> shutdownTimeoutMillis, Consumer<org.mule.runtime.api.scheduler.Scheduler> shutdownCallback, ProfilingService profilingService) {
        this.name = name + " @" + Integer.toHexString(this.hashCode());
        this.scheduledTasks = new ConcurrentHashMap(parallelTasksEstimate, 1.0f, Runtime.getRuntime().availableProcessors());
        this.executor = executor;
        this.scheduledExecutor = scheduledExecutor;
        this.quartzScheduler = quartzScheduler;
        this.threadType = threadsType;
        this.shutdownTimeoutMillis = shutdownTimeoutMillis;
        this.shutdownCallback = shutdownCallback;
        this.profilingService = profilingService;
        this.schedulableSuppressionLogger = new SuppressingLogger(LOGGER, 5000L, "Similar log entries will be suppressed for the following 5 seconds for scheduler '" + this.getName() + "'");
    }

    public ScheduledFuture<?> schedule(Runnable command, long delay, TimeUnit unit) {
        this.checkShutdown();
        Objects.requireNonNull(command);
        return this.doSchedule(this.newTaskFor(command, null), delay, unit);
    }

    public <V> ScheduledFuture<V> schedule(Callable<V> callable, long delay, TimeUnit unit) {
        this.checkShutdown();
        Objects.requireNonNull(callable);
        return this.doSchedule(this.newTaskFor(callable), delay, unit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <V> ScheduledFuture<V> doSchedule(RunnableFuture<V> task, long delay, TimeUnit unit) {
        this.shutdownLock.readLock().lock();
        try {
            RunnableFuture runnableFuture = task;
            synchronized (runnableFuture) {
                ScheduledFutureDecorator scheduled = new ScheduledFutureDecorator(this.scheduledExecutor.schedule(this.schedulableTask(task, () -> {
                    this.removeTask(task);
                    this.doSchedule(task, 10L, TimeUnit.MILLISECONDS);
                }), delay, unit), task, false);
                this.putTask(task, scheduled);
                ScheduledFutureDecorator scheduledFutureDecorator = scheduled;
                return scheduledFutureDecorator;
            }
        }
        finally {
            this.shutdownLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ScheduledFuture<?> scheduleAtFixedRate(Runnable command, long initialDelay, long period, TimeUnit unit) {
        this.shutdownLock.readLock().lock();
        try {
            RunnableRepeatableFutureDecorator task;
            this.checkShutdown();
            Objects.requireNonNull(command);
            RunnableRepeatableFutureDecorator runnableRepeatableFutureDecorator = task = new RunnableRepeatableFutureDecorator(() -> super.newTaskFor(command, null), command, t -> {
                if (t.isCancelled()) {
                    this.taskFinished((RunnableFuture<?>)t);
                }
            }, Thread.currentThread().getContextClassLoader(), this, command.getClass().getName(), this.idGenerator.getAndIncrement(), this.profilingService);
            synchronized (runnableRepeatableFutureDecorator) {
                ScheduledFutureDecorator scheduled = new ScheduledFutureDecorator(this.scheduledExecutor.scheduleAtFixedRate(this.schedulableTask(task, EMPTY_RUNNABLE), initialDelay, period, unit), task, true);
                this.putTask(task, scheduled);
                ScheduledFutureDecorator scheduledFutureDecorator = scheduled;
                return scheduledFutureDecorator;
            }
        }
        finally {
            this.shutdownLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ScheduledFuture<?> scheduleWithFixedDelay(Runnable command, long initialDelay, long delay, TimeUnit unit) {
        this.shutdownLock.readLock().lock();
        try {
            RunnableRepeatableFutureDecorator task;
            this.checkShutdown();
            Objects.requireNonNull(command);
            RunnableRepeatableFutureDecorator runnableRepeatableFutureDecorator = task = new RunnableRepeatableFutureDecorator(() -> super.newTaskFor(command, null), command, t -> this.fixedDelayWrapUp((RunnableFuture<?>)t, delay, unit), Thread.currentThread().getContextClassLoader(), this, command.getClass().getName(), this.idGenerator.getAndIncrement(), this.profilingService);
            synchronized (runnableRepeatableFutureDecorator) {
                ScheduledFutureDecorator scheduled = new ScheduledFutureDecorator(this.scheduledExecutor.schedule(this.schedulableTask(task, () -> this.fixedDelayWrapUp(task, delay, unit)), initialDelay, unit), task, true);
                this.putTask(task, scheduled);
                ScheduledFutureDecorator scheduledFutureDecorator = scheduled;
                return scheduledFutureDecorator;
            }
        }
        finally {
            this.shutdownLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fixedDelayWrapUp(RunnableFuture<?> task, long delay, TimeUnit unit) {
        RunnableFuture<?> runnableFuture = task;
        synchronized (runnableFuture) {
            if (!task.isCancelled()) {
                ScheduledFutureDecorator scheduled = new ScheduledFutureDecorator(this.scheduledExecutor.schedule(this.schedulableTask(task, () -> this.fixedDelayWrapUp(task, delay, unit)), delay, unit), task, true);
                this.scheduledTasks.replace(task, scheduled);
            } else {
                this.taskFinished(task);
            }
        }
    }

    public ScheduledFuture<?> scheduleWithCronExpression(Runnable command, String cronExpression) {
        return this.scheduleWithCronExpression(command, cronExpression, TimeZone.getDefault());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ScheduledFuture<?> scheduleWithCronExpression(Runnable command, String cronExpression, TimeZone timeZone) {
        this.shutdownLock.readLock().lock();
        try {
            RunnableRepeatableFutureDecorator task;
            this.checkShutdown();
            Objects.requireNonNull(command);
            RunnableRepeatableFutureDecorator runnableRepeatableFutureDecorator = task = new RunnableRepeatableFutureDecorator(() -> super.newTaskFor(command, null), command, t -> {
                if (t.isCancelled()) {
                    this.taskFinished((RunnableFuture<?>)t);
                }
            }, Thread.currentThread().getContextClassLoader(), this, command.getClass().getName(), this.idGenerator.getAndIncrement(), this.profilingService);
            synchronized (runnableRepeatableFutureDecorator) {
                JobDataMap jobDataMap = new JobDataMap();
                jobDataMap.put(QuartzCronJob.JOB_TASK_KEY, (Object)this.schedulableTask(task, EMPTY_RUNNABLE));
                JobDetail job = JobBuilder.newJob(this.jobClass).usingJobData(jobDataMap).build();
                CronTrigger trigger = (CronTrigger)TriggerBuilder.newTrigger().withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)cronExpression).withMisfireHandlingInstructionIgnoreMisfires().inTimeZone(timeZone)).build();
                try {
                    this.quartzScheduler.scheduleJob(job, (Trigger)trigger);
                }
                catch (SchedulerException e) {
                    throw new MuleRuntimeException((Throwable)e);
                }
                QuartzScheduledFuture scheduled = new QuartzScheduledFuture(this.quartzScheduler, (Trigger)trigger, task);
                this.putTask(task, scheduled);
                QuartzScheduledFuture quartzScheduledFuture = scheduled;
                return quartzScheduledFuture;
            }
        }
        finally {
            this.shutdownLock.readLock().unlock();
        }
    }

    protected <T> Runnable schedulableTask(RunnableFuture<T> task, Runnable rejectionCallback) {
        return () -> {
            block3: {
                try {
                    this.executor.execute(task);
                }
                catch (RejectedExecutionException e) {
                    if (this.executor.isShutdown()) break block3;
                    if (!this.recurrentTaskAlreadyRunning(task)) {
                        this.schedulableSuppressionLogger.log(e.getClass().getName() + " scheduling next execution of task " + task.toString() + ". Message was: " + e.getMessage());
                    }
                    rejectionCallback.run();
                }
            }
        };
    }

    private <T> boolean recurrentTaskAlreadyRunning(RunnableFuture<T> task) {
        return task instanceof RepeatableTaskWrapper && this.scheduledTasks.keySet().stream().anyMatch(st -> st instanceof RepeatableTaskWrapper && ((RepeatableTaskWrapper)((Object)st)).getCommand() == ((RepeatableTaskWrapper)((Object)task)).getCommand());
    }

    public void setJobClass(Class<? extends QuartzCronJob> jobClass) {
        this.jobClass = jobClass;
    }

    @Override
    public void shutdown() {
        this.shutdownLock.writeLock().lock();
        try {
            LOGGER.debug("Shutting down {}", (Object)this);
            this.doShutdown();
            this.stopFinally();
        }
        finally {
            this.shutdownLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doShutdown() {
        this.shutdown = true;
        Iterator<RunnableFuture<?>> iterator = this.scheduledTasks.keySet().iterator();
        while (iterator.hasNext()) {
            RunnableFuture<?> task;
            RunnableFuture<?> runnableFuture = task = iterator.next();
            synchronized (runnableFuture) {
                ScheduledFuture<?> scheduledFuture = this.scheduledTasks.get(task);
                if (scheduledFuture != null && (!(scheduledFuture instanceof ScheduledFutureDecorator) || ((ScheduledFutureDecorator)scheduledFuture).isPeriodic())) {
                    scheduledFuture.cancel(false);
                }
            }
        }
        this.profilingService = null;
    }

    @Override
    public List<Runnable> shutdownNow() {
        LOGGER.debug("Shutting down NOW {}", (Object)this);
        this.shutdownLock.writeLock().lock();
        try {
            List<Runnable> list = this.doShutdownNow();
            return list;
        }
        finally {
            this.stopFinally();
            this.shutdownLock.writeLock().unlock();
        }
    }

    protected List<Runnable> doShutdownNow() {
        this.shutdown = true;
        ArrayList<Runnable> tasks = new ArrayList<Runnable>(this.scheduledTasks.size());
        for (Map.Entry<RunnableFuture<?>, ScheduledFuture<?>> taskEntry : this.scheduledTasks.entrySet()) {
            taskEntry.getValue().cancel(true);
            taskEntry.getKey().cancel(true);
            if (!(taskEntry.getKey() instanceof RunnableFutureDecorator) || ((RunnableFutureDecorator)taskEntry.getKey()).isStarted()) continue;
            tasks.add(taskEntry.getKey());
        }
        this.scheduledTasks.clear();
        this.profilingService = null;
        return tasks;
    }

    @Override
    public boolean isShutdown() {
        return this.shutdown || this.executor.isShutdown();
    }

    @Override
    public boolean isTerminated() {
        if (this.shutdown && this.scheduledTasks.isEmpty()) {
            return true;
        }
        if (this.shutdown) {
            Thread currentThread = Thread.currentThread();
            return this.scheduledTasks.keySet().stream().noneMatch(t -> !currentThread.equals(t instanceof AbstractRunnableFutureDecorator ? ((AbstractRunnableFutureDecorator)t).getRunningThread() : null));
        }
        return false;
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        long stopNanos = System.nanoTime() + unit.toNanos(timeout);
        while (System.nanoTime() <= stopNanos) {
            if (this.isTerminated()) {
                return true;
            }
            if (!this.terminationLatch.await(50L, TimeUnit.MILLISECONDS)) continue;
            return true;
        }
        return this.isTerminated();
    }

    public void stop() {
        if (this.shutdown) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("{} is already stopped", (Object)this);
            }
            return;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Stopping {}", (Object)this);
        }
        this.shutdownLock.writeLock().lock();
        try {
            this.doShutdown();
            Long timeout = this.shutdownTimeoutMillis.get();
            if (!this.awaitTermination(timeout, TimeUnit.MILLISECONDS)) {
                List<Runnable> cancelledJobs = this.doShutdownNow();
                if (!this.awaitTermination(5L, TimeUnit.SECONDS)) {
                    LOGGER.warn("Scheduler {} did not shutdown gracefully after {} {}.", new Object[]{this, timeout, TimeUnit.MILLISECONDS});
                } else if (!cancelledJobs.isEmpty()) {
                    LOGGER.warn("Scheduler {} terminated, but it still had pending jobs after its graceful shutdown timeout.", (Object)this);
                }
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("The jobs {} were cancelled.", cancelledJobs);
                } else {
                    LOGGER.info("{} jobs were cancelled for this Scheduler.", (Object)cancelledJobs.size());
                }
            }
        }
        catch (InterruptedException ie) {
            this.doShutdownNow();
            Thread.currentThread().interrupt();
        }
        finally {
            this.stopFinally();
            this.shutdownLock.writeLock().unlock();
        }
    }

    protected void stopFinally() {
        this.shutdownCallback.accept(this);
        this.tryTerminate();
    }

    @Override
    protected <T> RunnableFuture<T> newTaskFor(Callable<T> callable) {
        return this.newDecoratedTaskFor(super.newTaskFor(callable), callable.getClass());
    }

    @Override
    protected <T> RunnableFuture<T> newTaskFor(Runnable runnable, T value) {
        return this.newDecoratedTaskFor(super.newTaskFor(runnable, value), runnable.getClass());
    }

    private <T> RunnableFuture<T> newDecoratedTaskFor(RunnableFuture<T> newTaskFor, Class<?> taskClass) {
        return new RunnableFutureDecorator<T>(newTaskFor, Thread.currentThread().getContextClassLoader(), this, taskClass.getName(), this.idGenerator.getAndIncrement(), this.profilingService);
    }

    @Override
    public void execute(Runnable command) {
        this.checkShutdown();
        RunnableFuture<Object> runnableFutureCommand = command instanceof RunnableFuture ? (RunnableFuture<Object>)command : this.newTaskFor(command, null);
        this.putTask(runnableFutureCommand, NULL_SCHEDULED_FUTURE);
        try {
            this.executor.execute(runnableFutureCommand);
        }
        catch (Exception e) {
            this.removeTask(runnableFutureCommand);
            throw e;
        }
    }

    protected void checkShutdown() {
        if (this.isShutdown()) {
            throw new RejectedExecutionException(this.toString() + " already shutdown");
        }
    }

    protected void taskFinished(RunnableFuture<?> task) {
        this.removeTask(task);
        this.tryTerminate();
    }

    protected void putTask(RunnableFuture<?> task, ScheduledFuture<?> scheduledFuture) {
        this.scheduledTasks.put(task, scheduledFuture);
    }

    protected ScheduledFuture<?> removeTask(RunnableFuture<?> task) {
        return this.scheduledTasks.remove(task);
    }

    protected void tryTerminate() {
        if (this.isTerminated()) {
            this.terminationLatch.countDown();
        }
    }

    public ThreadType getThreadType() {
        return this.threadType;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        if (LOGGER.isDebugEnabled()) {
            return (Object)((Object)this.getThreadType()) + " - " + this.getName() + "{" + System.lineSeparator() + "  executor: " + this.executor.toString() + System.lineSeparator() + "  shutdown: " + this.shutdown + System.lineSeparator() + "}";
        }
        return (Object)((Object)this.getThreadType()) + " - " + this.getName() + "{shutdown: " + this.shutdown + "}";
    }
}

