/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.privileged.exception;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.inject.Inject;
import org.mule.api.annotation.NoExtend;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.notification.NotificationDispatcher;
import org.mule.runtime.core.api.processor.AbstractMessageProcessorOwner;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.privileged.exception.DefaultExceptionListener;

@NoExtend
public abstract class AbstractDeclaredExceptionListener
extends AbstractMessageProcessorOwner {
    @Inject
    private NotificationDispatcher notificationFirer;
    private DefaultExceptionListener exceptionListener;
    private final List<Processor> messageProcessors = new CopyOnWriteArrayList<Processor>();
    private final AtomicBoolean initialised = new AtomicBoolean(false);
    private String logException = Boolean.TRUE.toString();

    public List<Processor> getMessageProcessors() {
        return this.messageProcessors;
    }

    public void setMessageProcessors(List<Processor> processors) {
        if (processors == null) {
            throw new IllegalArgumentException("List of targets = null");
        }
        this.messageProcessors.clear();
        this.messageProcessors.addAll(processors);
    }

    @Override
    public synchronized void initialise() throws InitialisationException {
        if (!this.isInitialised()) {
            this.doInitialise();
            super.initialise();
            if (this.exceptionListener == null) {
                this.exceptionListener = new DefaultExceptionListener();
                this.exceptionListener.setNotificationFirer(this.notificationFirer);
            }
            this.exceptionListener.setRepresentation(this.getClass().getSimpleName() + (this.getLocation() != null ? " @ " + this.getLocation().getLocation() : ""));
            this.initialised.set(true);
        }
    }

    public boolean isInitialised() {
        return this.initialised.get();
    }

    protected void doInitialise() throws InitialisationException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Initialising exception listener: " + this.toString());
        }
    }

    @Override
    protected List<Processor> getOwnedMessageProcessors() {
        return this.messageProcessors;
    }

    public NotificationDispatcher getNotificationFirer() {
        return this.notificationFirer;
    }

    public DefaultExceptionListener getExceptionListener() {
        return this.exceptionListener;
    }

    public void setExceptionListener(DefaultExceptionListener exceptionListener) {
        this.exceptionListener = exceptionListener;
    }

    public String getLogException() {
        return this.logException;
    }

    public void setLogException(String logException) {
        this.logException = logException;
    }
}

