/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.transformer.simple;

import java.nio.charset.Charset;
import java.text.NumberFormat;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.core.api.transformer.AbstractTransformer;
import org.mule.runtime.core.api.transformer.DiscoverableTransformer;
import org.mule.runtime.core.api.transformer.TransformerException;
import org.mule.runtime.core.privileged.util.NumberUtils;

public class StringToNumber
extends AbstractTransformer
implements DiscoverableTransformer {
    private NumberFormat numberFormat;
    private int priorityWeighting = 2;

    public StringToNumber() {
        this.registerSourceType(DataType.STRING);
        this.setReturnDataType(DataType.NUMBER);
    }

    public StringToNumber(NumberFormat numberFormat) {
        this();
        this.numberFormat = numberFormat;
    }

    @Override
    public Object doTransform(Object src, Charset outputEncoding) throws TransformerException {
        if (src == null) {
            return null;
        }
        if (this.numberFormat != null) {
            try {
                return NumberUtils.convertNumberToTargetClass(this.numberFormat.parse((String)src), this.getType());
            }
            catch (Exception e) {
                throw new TransformerException(this, (Throwable)e);
            }
        }
        return NumberUtils.parseNumber((String)src, this.getType());
    }

    private Class<? extends Number> getType() {
        return super.getReturnDataType().getType();
    }

    @Override
    public void setReturnDataType(DataType type) {
        if (!Number.class.isAssignableFrom(type.getType())) {
            throw new IllegalArgumentException("This transformer only supports Number return types.");
        }
        super.setReturnDataType(type);
    }

    @Override
    public int getPriorityWeighting() {
        return this.priorityWeighting;
    }

    @Override
    public void setPriorityWeighting(int priorityWeighting) {
        this.priorityWeighting = priorityWeighting;
    }
}

