/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.profiling.producer;

import java.util.Map;
import java.util.function.Function;
import org.mule.runtime.api.profiling.ProfilingProducerScope;
import org.mule.runtime.api.profiling.type.ProfilingEventType;
import org.mule.runtime.api.profiling.type.context.ByteBufferProviderEventContext;
import org.mule.runtime.core.internal.profiling.DefaultProfilingService;
import org.mule.runtime.core.internal.profiling.ResettableProfilingDataProducer;
import org.mule.runtime.feature.internal.config.profiling.ProfilingDataProducerStatus;
import org.mule.runtime.feature.internal.config.profiling.ProfilingFeatureFlaggingService;

public class ByteBufferProfilingDataProducer
implements ResettableProfilingDataProducer<ByteBufferProviderEventContext, Map> {
    private final DefaultProfilingService defaultProfilingService;
    private final ProfilingEventType<ByteBufferProviderEventContext> profilingEventType;
    private final ProfilingDataProducerStatus profilingProducerStatus;

    public ByteBufferProfilingDataProducer(DefaultProfilingService defaultProfilingService, ProfilingEventType<ByteBufferProviderEventContext> profilingEventType, ProfilingProducerScope profilingProducerScope, ProfilingFeatureFlaggingService featureFlaggingService) {
        this.defaultProfilingService = defaultProfilingService;
        this.profilingEventType = profilingEventType;
        this.profilingProducerStatus = featureFlaggingService.getProfilingDataProducerStatus(profilingEventType, profilingProducerScope);
    }

    public void triggerProfilingEvent(ByteBufferProviderEventContext profilerEventContext) {
        if (this.profilingProducerStatus.isEnabled()) {
            this.defaultProfilingService.notifyEvent(profilerEventContext, this.profilingEventType);
        }
    }

    public void triggerProfilingEvent(Map sourceData, Function<Map, ByteBufferProviderEventContext> transformation) {
        if (this.profilingProducerStatus.isEnabled()) {
            this.defaultProfilingService.notifyEvent(transformation.apply(sourceData), this.profilingEventType);
        }
    }

    @Override
    public void reset() {
        this.profilingProducerStatus.reset();
    }
}

